/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.spring.boot.open2internet.http;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.mvnsearch.spring.boot.open2internet.JsonSupport;
import org.mvnsearch.spring.boot.open2internet.http.HttpRequest;
import org.mvnsearch.spring.boot.open2internet.http.HttpResponse;
import org.mvnsearch.spring.boot.open2internet.http.LocalHttpServiceClient;
import org.reactivestreams.Publisher;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class LocalHttpServiceClientImpl
extends JsonSupport
implements LocalHttpServiceClient {
    private WebClient webClient;
    private String localBaseWebUri;

    public LocalHttpServiceClientImpl(ObjectMapper objectMapper, String localBaseWebUri) {
        super(objectMapper);
        this.localBaseWebUri = localBaseWebUri;
        this.webClient = WebClient.create((String)localBaseWebUri);
    }

    @Override
    public String getLocalBaseWebUri() {
        return this.localBaseWebUri;
    }

    @Override
    public Mono<HttpResponse> getHttpResponse(HttpRequest httpRequest) {
        WebClient.RequestBodySpec webRequest = (WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf((String)httpRequest.getMethod())).uri(httpRequest.getRequestUri(), new Object[0])).headers(httpHeaders -> {
            for (Map.Entry<String, String> entry : httpRequest.getHeaders().entrySet()) {
                httpHeaders.add(entry.getKey(), entry.getValue());
            }
        });
        if (httpRequest.getBody() != null) {
            webRequest.body((Publisher)Mono.just((Object)new ByteArrayResource(httpRequest.getBody())), ByteArrayResource.class);
        }
        Mono clientResponseMono = webRequest.exchange();
        return clientResponseMono.map(clientResponse -> {
            HttpResponse httpResponse = new HttpResponse();
            httpResponse.setStatus(clientResponse.rawStatusCode());
            HttpHeaders httpHeaders = clientResponse.headers().asHttpHeaders();
            for (String name : httpHeaders.keySet()) {
                httpResponse.addHeader(name, httpHeaders.getFirst(name));
            }
            return httpResponse;
        }).zipWith(clientResponseMono.flatMap(clientResponse -> clientResponse.bodyToMono(ByteArrayResource.class)), (httpResponse, byteArrayResource) -> {
            if (byteArrayResource != null) {
                httpResponse.setBody(byteArrayResource.getByteArray());
            }
            return httpResponse;
        });
    }
}

