/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.spring.boot.open2internet;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.PreDestroy;
import org.mvnsearch.spring.boot.open2internet.Open2InternetEndpoint;
import org.mvnsearch.spring.boot.open2internet.Open2InternetProperties;
import org.mvnsearch.spring.boot.open2internet.http.LocalHttpServiceClient;
import org.mvnsearch.spring.boot.open2internet.http.LocalHttpServiceClientImpl;
import org.mvnsearch.spring.boot.open2internet.rsocket.Open2InternetAuthentication;
import org.mvnsearch.spring.boot.open2internet.rsocket.RSocketConnectionManager;
import org.mvnsearch.spring.boot.open2internet.rsocket.RSocketConnectionManagerImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={Open2InternetProperties.class})
public class Open2InternetAutoConfiguration
implements ApplicationListener<WebServerInitializedEvent> {
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private Open2InternetProperties properties;
    private LocalHttpServiceClient localHttpServiceClient;
    private RSocketConnectionManager rSocketConnectionManager;
    private Open2InternetEndpoint endpoint = new Open2InternetEndpoint();

    public void onApplicationEvent(WebServerInitializedEvent event) {
        int localListenPort = event.getWebServer().getPort();
        String localBaseWebUri = "http://127.0.0.1:" + localListenPort;
        this.localHttpServiceClient = new LocalHttpServiceClientImpl(this.objectMapper, localBaseWebUri);
        Open2InternetAuthentication authentication = new Open2InternetAuthentication(this.properties.getAccessToken(), this.properties.getCustomDomain());
        this.rSocketConnectionManager = new RSocketConnectionManagerImpl(this.objectMapper, this.properties.getUri(), authentication, this.localHttpServiceClient);
        this.endpoint.setProperties(this.properties);
        this.endpoint.setLocalHttpServiceClient(this.localHttpServiceClient);
        this.endpoint.setRsocketConnectionManager(this.rSocketConnectionManager);
        if (this.properties.isEnable()) {
            this.rSocketConnectionManager.connect();
        }
    }

    @Bean
    public Open2InternetEndpoint open2InternetEndpoint() {
        return this.endpoint;
    }

    @PreDestroy
    public void destroy() {
        this.rSocketConnectionManager.disConnect();
    }
}

