/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.oauth2.internal;

import java.util.Objects;
import org.mule.extension.oauth2.internal.TokenResponseParameterOutputResolver;
import org.mule.extension.oauth2.internal.tokenmanager.TokenManagerConfig;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;

public class OAuthOperations {
    public void invalidateOauthContext(TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        tokenManager.getConfigOAuthContext().clearContextForResourceOwner(resourceOwnerId);
    }

    public String retrieveAccessToken(TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getAccessToken();
    }

    public String retrieveRefreshToken(TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getRefreshToken();
    }

    public String retrieveExpiresIn(TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getExpiresIn();
    }

    public String retrieveState(TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getState();
    }

    @OutputResolver(output=TokenResponseParameterOutputResolver.class)
    public Object retrieveCustomTokenResponseParam(TokenManagerConfig tokenManager, @Optional(defaultValue="default") String resourceOwnerId, String key) {
        return this.getContextForResourceOwner(tokenManager, resourceOwnerId).getTokenResponseParameters().get(key);
    }

    private void validateResourceOwnerId(String resourceOwnerId) {
        Objects.requireNonNull(resourceOwnerId, "Resource owner id cannot be null");
    }

    private ResourceOwnerOAuthContext getContextForResourceOwner(TokenManagerConfig tokenManager, String resourceOwnerId) {
        this.validateResourceOwnerId(resourceOwnerId);
        return tokenManager.getConfigOAuthContext().getContextForResourceOwner(resourceOwnerId);
    }
}

