/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.transaction;

import org.mule.transaction.AbstractSingleResourceTransaction;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOManagementContext;
import org.mule.umo.UMOTransaction;
import org.mule.umo.UMOTransactionFactory;
import org.springframework.jdbc.datasource.ConnectionHolder;
import org.springframework.jms.connection.JmsResourceHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionFactory
implements UMOTransactionFactory {
    private PlatformTransactionManager manager;

    public UMOTransaction beginTransaction(UMOManagementContext managementContext) throws TransactionException {
        return new SpringTransaction();
    }

    public boolean isTransacted() {
        return true;
    }

    public synchronized PlatformTransactionManager getManager() {
        return this.manager;
    }

    public synchronized void setManager(PlatformTransactionManager manager) {
        this.manager = manager;
    }

    public class SpringTransaction
    extends AbstractSingleResourceTransaction {
        protected final TransactionStatus status;

        public SpringTransaction() {
            this.status = SpringTransactionFactory.this.manager.getTransaction(null);
        }

        protected void doBegin() throws TransactionException {
        }

        protected void doCommit() throws TransactionException {
            SpringTransactionFactory.this.manager.commit(this.status);
        }

        protected void doRollback() throws TransactionException {
            SpringTransactionFactory.this.manager.rollback(this.status);
        }

        public Object getResource(Object key) {
            Object res = TransactionSynchronizationManager.getResource((Object)key);
            if (res != null) {
                if (!(res instanceof ConnectionHolder)) {
                    if (res instanceof JmsResourceHolder) {
                        return ((JmsResourceHolder)res).getConnection();
                    }
                } else {
                    return ((ConnectionHolder)res).getConnection();
                }
            }
            return res;
        }

        public boolean hasResource(Object key) {
            return this.getResource(key) != null;
        }

        public void bindResource(Object key, Object resource) throws TransactionException {
            throw new UnsupportedOperationException();
        }

        public void setRollbackOnly() {
            super.setRollbackOnly();
            this.status.setRollbackOnly();
        }
    }
}

