/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.ConfigurationException;
import org.mule.config.ReaderResource;
import org.mule.config.i18n.CoreMessages;
import org.mule.extras.spring.config.MuleApplicationContext;
import org.mule.umo.UMOException;
import org.mule.umo.manager.UMOManager;
import org.mule.util.ArrayUtils;
import org.mule.util.PropertiesUtils;
import org.mule.util.StringUtils;

public class SpringConfigurationBuilder
implements ConfigurationBuilder {
    protected final transient Log logger = LogFactory.getLog(this.getClass());

    public UMOManager configure(ReaderResource[] configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(ReaderResource[] configResources, Properties startupProperties) throws ConfigurationException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public UMOManager configure(String configResources) throws ConfigurationException {
        return this.configure(configResources, null);
    }

    public UMOManager configure(String configResources, String startupPropertiesFile) throws ConfigurationException {
        if (StringUtils.isNotBlank((String)startupPropertiesFile)) {
            try {
                startupPropertiesFile = StringUtils.trimToEmpty((String)startupPropertiesFile);
                Properties startupProperties = PropertiesUtils.loadProperties((String)startupPropertiesFile, this.getClass());
                ((MuleManager)MuleManager.getInstance()).addProperties((Map)startupProperties);
            }
            catch (IOException e) {
                throw new ConfigurationException(CoreMessages.failedToStart((String)"Mule server from builder"), (Throwable)e);
            }
        }
        String[] resources = StringUtils.splitAndTrim((String)configResources, (String)",");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("There is/are " + resources.length + " configuration resource(s): " + ArrayUtils.toString((Object)resources)));
        }
        MuleManager.getConfiguration().setConfigResources(resources);
        new MuleApplicationContext(resources);
        try {
            if (System.getProperty("org.mule.start.after.config", "true").equalsIgnoreCase("true")) {
                MuleManager.getInstance().start();
            }
        }
        catch (UMOException e) {
            throw new ConfigurationException(CoreMessages.failedToStart((String)"Mule server from builder"), (Throwable)e);
        }
        return MuleManager.getInstance();
    }

    public boolean isConfigured() {
        return MuleManager.isInstanciated();
    }
}

