/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.beans.PropertyEditor;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.io.DOMReader;
import org.mule.config.MuleDtdResolver;
import org.mule.extras.spring.config.MuleBeanDefinitionDocumentReader;
import org.mule.extras.spring.config.MuleResourceLoader;
import org.mule.extras.spring.config.TransformerEditor;
import org.mule.umo.transformer.UMOTransformer;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;

public class MuleBeanDefinitionReader
extends XmlBeanDefinitionReader {
    private int contextCount = 0;
    private int configCount = 0;
    private MuleDtdResolver dtdResolver = null;

    public MuleBeanDefinitionReader(BeanDefinitionRegistry beanDefinitionRegistry, int configCount) {
        super(beanDefinitionRegistry);
        this.setDocumentReaderClass(MuleBeanDefinitionDocumentReader.class);
        this.setResourceLoader((ResourceLoader)new MuleResourceLoader());
        this.setValidationMode(2);
        this.setEntityResolver(this.createEntityResolver());
        this.configCount = configCount;
        ((DefaultListableBeanFactory)beanDefinitionRegistry).registerCustomEditor(UMOTransformer.class, (PropertyEditor)new TransformerEditor());
    }

    public int registerBeanDefinitions(Document document, Resource resource) throws BeansException {
        try {
            Document newDocument = this.transformDocument(document);
            int n = super.registerBeanDefinitions(newDocument, resource);
            return n;
        }
        catch (Exception e) {
            throw new FatalBeanException("Failed to read config resource: " + resource, (Throwable)e);
        }
        finally {
            this.incConfigCount();
        }
    }

    public static Transformer createTransformer(Source source) throws TransformerConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(source);
        return transformer;
    }

    protected Document transformDocument(Document document) throws IOException, TransformerException {
        if (this.getXslResource() != null) {
            Transformer transformer = MuleBeanDefinitionReader.createTransformer(this.createXslSource());
            DOMResult result = new DOMResult();
            transformer.setParameter("firstContext", this.isFirstContext());
            transformer.transform(new DOMSource(document), result);
            if (this.logger.isDebugEnabled()) {
                try {
                    String xml = new DOMReader().read((Document)result.getNode()).asXML();
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Transformed document is:\n" + xml));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return (Document)result.getNode();
        }
        return document;
    }

    protected Source createXslSource() throws IOException {
        return new StreamSource(this.getXslResource().getInputStream(), this.getXslResource().getURL().toString());
    }

    protected ClassPathResource getXslResource() {
        String xsl = this.dtdResolver.getXslForDtd();
        if (xsl != null) {
            return new ClassPathResource(xsl);
        }
        return null;
    }

    protected EntityResolver createEntityResolver() {
        if (this.dtdResolver == null) {
            MuleDtdResolver muleSpringResolver = new MuleDtdResolver("mule-spring-configuration.dtd", "mule-to-spring.xsl", (EntityResolver)new BeansDtdResolver());
            this.dtdResolver = new MuleDtdResolver("mule-configuration.dtd", "mule-to-spring.xsl", (EntityResolver)muleSpringResolver);
        }
        return this.dtdResolver;
    }

    public boolean isFirstContext() {
        return this.contextCount == 0;
    }

    private void incConfigCount() {
        ++this.contextCount;
        if (this.contextCount >= this.configCount) {
            this.contextCount = 0;
        }
    }
}

