/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.CoreMessages;
import org.mule.config.i18n.MessageFactory;
import org.mule.extras.spring.config.CachedResource;
import org.mule.extras.spring.config.MuleApplicationContext;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.ArrayUtils;
import org.mule.util.StringUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;

public class SpringContainerContext
extends AbstractContainerContext
implements BeanFactoryAware {
    public static final String SPRING_DOCTYPE_REF = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE beans PUBLIC \"-//SPRING//DTD BEAN//EN\" \"http://www.springframework.org/dtd/spring-beans.dtd\">\n";
    protected BeanFactory beanFactory;
    protected BeanFactory externalBeanFactory;
    protected String configResources;
    protected String configXml;

    public SpringContainerContext() {
        super("spring");
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        if (this.getBeanFactory() == null) {
            throw new IllegalStateException("Spring Application context has not been set");
        }
        if (key == null) {
            throw new ObjectNotFoundException("Component not found for null key");
        }
        if (key instanceof Class) {
            throw new ObjectNotFoundException("The container is unable to build single instance of " + ((Class)key).getName() + " number of instances found was: 0");
        }
        try {
            return this.getBeanFactory().getBean(key.toString());
        }
        catch (BeansException e) {
            throw new ObjectNotFoundException("Component not found for key: " + key.toString(), (Throwable)e);
        }
    }

    public void configure(Reader reader) throws ContainerException {
        Resource[] resources;
        try {
            resources = new Resource[]{new CachedResource(reader, MuleManager.getConfiguration().getEncoding())};
        }
        catch (IOException e) {
            throw new ContainerException(MessageFactory.createStaticMessage((String)"Unable to read resource"), (Throwable)e);
        }
        this.setExternalBeanFactory((BeanFactory)new MuleApplicationContext(resources));
    }

    public void initialise() throws InitialisationException {
        if (this.configXml != null) {
            Resource[] resources;
            String encoding = MuleManager.getConfiguration().getEncoding();
            try {
                resources = new Resource[]{new CachedResource(this.configXml, MuleManager.getConfiguration().getEncoding())};
            }
            catch (UnsupportedEncodingException e) {
                throw new InitialisationException(CoreMessages.failedToConvertStringUsingEncoding((String)encoding), (Object)e);
            }
            this.setExternalBeanFactory((BeanFactory)new MuleApplicationContext(resources));
        } else if (this.configResources != null) {
            String[] resources = StringUtils.splitAndTrim((String)this.configResources, (String)",");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("There is/are " + resources.length + " configuration resource(s): " + ArrayUtils.toString((Object)resources)));
            }
            this.setExternalBeanFactory((BeanFactory)new MuleApplicationContext(resources));
        }
    }

    public void dispose() {
        if (this.externalBeanFactory instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.externalBeanFactory).close();
        }
        super.dispose();
    }

    public BeanFactory getBeanFactory() {
        if (this.externalBeanFactory != null) {
            return this.externalBeanFactory;
        }
        return this.beanFactory;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setExternalBeanFactory(BeanFactory factory) {
        this.externalBeanFactory = factory;
    }

    public String getConfigXml() {
        return this.configXml;
    }

    public void setConfigXml(String configXml) {
        this.configXml = configXml;
    }

    public String getConfiguration() {
        return this.configXml;
    }

    public void setConfiguration(String configuration) {
        this.configXml = configuration;
    }

    public String getConfigResources() {
        return this.configResources;
    }

    public void setConfigResources(String configResources) {
        this.configResources = configResources;
    }

    public String getConfigFile() {
        return this.configResources;
    }

    public void setConfigFile(String configFile) throws ConfigurationException {
        this.configResources = configFile;
    }
}

