/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.events;

import edu.emory.mathcs.backport.java.util.concurrent.CopyOnWriteArraySet;
import edu.emory.mathcs.backport.java.util.concurrent.ExecutorService;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.MuleRuntimeException;
import org.mule.config.MuleConfiguration;
import org.mule.config.builders.QuickConfigurationBuilder;
import org.mule.config.i18n.Message;
import org.mule.extras.spring.SpringContainerContext;
import org.mule.extras.spring.events.ApplicationEventException;
import org.mule.extras.spring.events.AsynchronousEventListener;
import org.mule.extras.spring.events.MuleApplicationEvent;
import org.mule.extras.spring.events.MuleEventListener;
import org.mule.extras.spring.events.MuleSubscriptionEventListener;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.RequestContext;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.model.seda.SedaModel;
import org.mule.providers.AbstractConnector;
import org.mule.routing.filters.ObjectFilter;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.routing.UMOInboundRouterCollection;
import org.mule.umo.transformer.TransformerException;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.ClassUtils;
import org.mule.util.MapUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;

public class MuleEventMulticaster
implements ApplicationEventMulticaster,
ApplicationContextAware,
DisposableBean {
    public static final String EVENT_MULTICASTER_DESCRIPTOR_NAME = "muleEventMulticasterDescriptor";
    protected static final Log logger = LogFactory.getLog((Class)MuleEventMulticaster.class);
    protected final Set listeners = new CopyOnWriteArraySet();
    protected boolean asynchronous = false;
    protected ExecutorService asyncPool = null;
    protected Map endpointMappings = null;
    protected String[] subscriptions = null;
    protected ApplicationContext applicationContext;
    protected UMODescriptor descriptor;
    protected UMOComponent component;
    protected Class subscriptionFilter = WildcardFilter.class;
    protected ExceptionListener exceptionListener = new LoggingExceptionListener();
    static /* synthetic */ Class class$org$springframework$context$ApplicationListener;

    public void addApplicationListener(ApplicationListener listener) {
        ApplicationListener listenerToAdd = listener;
        if (this.asynchronous) {
            listenerToAdd = new AsynchronousEventListener(this.asyncPool, listener);
        }
        this.listeners.add(listenerToAdd);
    }

    public void removeApplicationListener(ApplicationListener listener) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ApplicationListener applicationListener = (ApplicationListener)iterator.next();
            if (applicationListener instanceof AsynchronousEventListener) {
                if (!((AsynchronousEventListener)applicationListener).getListener().equals(listener)) continue;
                this.listeners.remove(applicationListener);
                return;
            }
            if (!applicationListener.equals(listener)) continue;
            this.listeners.remove(applicationListener);
            return;
        }
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    public void multicastEvent(ApplicationEvent e) {
        MuleApplicationEvent muleEvent = null;
        if (e instanceof ContextRefreshedEvent) {
            if (MuleManager.isInstanciated() && !MuleManager.getInstance().isInitialised()) {
                try {
                    this.registerMulticasterDescriptor();
                }
                catch (UMOException ex) {
                    throw new MuleRuntimeException(new Message("spring", 1), (Throwable)ex);
                }
            } else {
                this.initMule();
            }
        } else {
            if (e instanceof ContextClosedEvent) {
                MuleManager.getInstance().dispose();
                return;
            }
            if (e instanceof MuleApplicationEvent && (muleEvent = (MuleApplicationEvent)e).getMuleEventContext() == null) {
                try {
                    this.dispatchEvent(muleEvent);
                }
                catch (ApplicationEventException e1) {
                    this.exceptionListener.exceptionThrown(e1);
                }
                return;
            }
        }
        Iterator iterator = this.listeners.iterator();
        block4: while (iterator.hasNext()) {
            ApplicationListener listener = (ApplicationListener)iterator.next();
            if (muleEvent != null) {
                if (listener instanceof AsynchronousEventListener) {
                    AsynchronousEventListener asyncListener = (AsynchronousEventListener)listener;
                    if (asyncListener.getListener() instanceof MuleSubscriptionEventListener) {
                        if (!this.isSubscriptionMatch(muleEvent.getEndpoint(), ((MuleSubscriptionEventListener)asyncListener.getListener()).getSubscriptions())) continue;
                        asyncListener.onApplicationEvent(muleEvent);
                        continue;
                    }
                    if (asyncListener.getListener() instanceof MuleEventListener) {
                        asyncListener.onApplicationEvent(muleEvent);
                        continue;
                    }
                    if (asyncListener.getListener() instanceof MuleEventListener) continue;
                    asyncListener.onApplicationEvent(e);
                    continue;
                }
                if (listener instanceof MuleSubscriptionEventListener) {
                    if (!this.isSubscriptionMatch(muleEvent.getEndpoint(), ((MuleSubscriptionEventListener)listener).getSubscriptions())) continue;
                    listener.onApplicationEvent((ApplicationEvent)muleEvent);
                    continue;
                }
                if (!(listener instanceof MuleEventListener)) continue;
                listener.onApplicationEvent((ApplicationEvent)muleEvent);
                continue;
            }
            if (listener instanceof AsynchronousEventListener && !(((AsynchronousEventListener)listener).getListener() instanceof MuleEventListener)) {
                listener.onApplicationEvent(e);
                continue;
            }
            if (!(listener instanceof MuleEventListener)) {
                listener.onApplicationEvent(e);
                continue;
            }
            for (int i = 0; i < listener.getClass().getInterfaces().length; ++i) {
                if (!listener.getClass().getInterfaces()[i].equals(class$org$springframework$context$ApplicationListener == null ? MuleEventMulticaster.class$("org.springframework.context.ApplicationListener") : class$org$springframework$context$ApplicationListener)) continue;
                listener.onApplicationEvent(e);
                continue block4;
            }
        }
    }

    private boolean isSubscriptionMatch(String endpoint, String[] subscriptions) {
        for (int i = 0; i < subscriptions.length; ++i) {
            String subscription = MapUtils.getString((Map)MuleManager.getInstance().getEndpointIdentifiers(), (Object)subscriptions[i], (String)subscriptions[i]);
            ObjectFilter filter = this.createFilter(subscription);
            if (!filter.accept((Object)endpoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isAsynchronous() {
        return this.asynchronous;
    }

    public void setAsynchronous(boolean asynchronous) {
        this.asynchronous = asynchronous;
        if (asynchronous) {
            if (this.asyncPool == null) {
                this.asyncPool = MuleManager.getConfiguration().getDefaultThreadingProfile().createPool("spring-events");
            }
        } else if (this.asyncPool != null) {
            this.asyncPool.shutdown();
            this.asyncPool = null;
        }
    }

    public void onMuleEvent(UMOEventContext context) throws TransformerException, MalformedEndpointException {
        this.multicastEvent(new MuleApplicationEvent(context.getTransformedMessage(), context, this.applicationContext));
        context.setStopFurtherProcessing(true);
    }

    protected void dispatchEvent(MuleApplicationEvent applicationEvent) throws ApplicationEventException {
        UMOEndpoint endpoint = null;
        try {
            endpoint = MuleEndpoint.getOrCreateEndpointForUri((String)applicationEvent.getEndpoint(), (String)"sender");
        }
        catch (UMOException e) {
            throw new ApplicationEventException("Failed to get endpoint for endpointUri: " + applicationEvent.getEndpoint(), e);
        }
        if (endpoint != null) {
            try {
                MuleMessage message = new MuleMessage(applicationEvent.getSource(), applicationEvent.getProperties());
                if (applicationEvent.getMuleEventContext() != null) {
                    applicationEvent.getMuleEventContext().setStopFurtherProcessing(true);
                    applicationEvent.getMuleEventContext().dispatchEvent((UMOMessage)message, endpoint);
                }
                MuleSession session = new MuleSession((UMOMessage)message, ((AbstractConnector)endpoint.getConnector()).getSessionHandler(), this.component);
                RequestContext.setEvent((UMOEvent)new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)endpoint, (UMOSession)session, false));
                if (endpoint.getTransformer() != null) {
                    message = new MuleMessage(endpoint.getTransformer().transform(applicationEvent.getSource()), applicationEvent.getProperties());
                }
                endpoint.dispatch((UMOEvent)new MuleEvent((UMOMessage)message, (UMOImmutableEndpoint)endpoint, (UMOSession)session, false));
            }
            catch (Exception e1) {
                throw new ApplicationEventException("Failed to dispatch event: " + e1.getMessage(), e1);
            }
        } else {
            throw new ApplicationEventException("Failed endpoint using name: " + applicationEvent.getEndpoint());
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected void initMule() {
        try {
            if (this.applicationContext.containsBean(EVENT_MULTICASTER_DESCRIPTOR_NAME)) {
                this.descriptor = (UMODescriptor)this.applicationContext.getBean(EVENT_MULTICASTER_DESCRIPTOR_NAME);
            }
            if (this.applicationContext.containsBean("muleManager")) {
                this.registerMulticasterDescriptor();
                return;
            }
            UMOManager manager = MuleManager.getInstance();
            Map map = this.applicationContext.getBeansOfType(MuleConfiguration.class);
            if (map != null && map.size() > 0) {
                MuleManager.setConfiguration((MuleConfiguration)((MuleConfiguration)map.values().iterator().next()));
            }
            if (!manager.isStarted()) {
                MuleManager.getConfiguration().setSynchronous(!this.asynchronous);
                this.registerEndpointMappings();
            }
            SpringContainerContext containerContext = new SpringContainerContext();
            containerContext.setBeanFactory((BeanFactory)this.applicationContext);
            manager.setContainerContext(null);
            manager.setContainerContext((UMOContainerContext)containerContext);
            this.registerConnectors();
            this.registerTransformers();
            this.registerGlobalEndpoints();
            this.registerMulticasterDescriptor();
            if (!manager.isStarted()) {
                manager.start();
            }
        }
        catch (UMOException e) {
            throw new MuleRuntimeException(new Message("spring", 1), (Throwable)e);
        }
    }

    protected void registerMulticasterDescriptor() throws UMOException {
        if (this.descriptor == null) {
            this.descriptor = this.getDefaultDescriptor();
            this.setSubscriptionsOnDescriptor((MuleDescriptor)this.descriptor);
            this.component = MuleManager.getInstance().lookupModel("_system").registerComponent(this.descriptor);
        }
    }

    protected void setSubscriptionsOnDescriptor(MuleDescriptor descriptor) throws UMOException {
        ArrayList<String> endpoints = new ArrayList<String>();
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ApplicationListener listener = (ApplicationListener)iterator.next();
            if (listener instanceof AsynchronousEventListener) {
                listener = ((AsynchronousEventListener)listener).getListener();
            }
            if (!(listener instanceof MuleSubscriptionEventListener)) continue;
            String[] subscriptions = ((MuleSubscriptionEventListener)listener).getSubscriptions();
            for (int i = 0; i < subscriptions.length; ++i) {
                boolean isSoap;
                if (subscriptions[i].indexOf("*") != -1 || !MuleEndpointURI.isMuleUri((String)subscriptions[i]) || (isSoap = this.registerAsSoap(subscriptions[i], listener))) continue;
                endpoints.add(subscriptions[i]);
            }
        }
        if (endpoints.size() > 0) {
            iterator = endpoints.iterator();
            while (iterator.hasNext()) {
                String endpoint = (String)iterator.next();
                descriptor.getInboundRouter().addEndpoint((UMOEndpoint)new MuleEndpoint(endpoint, true));
            }
        }
    }

    private boolean registerAsSoap(String endpoint, Object listener) throws UMOException {
        if (endpoint.startsWith("glue") || endpoint.startsWith("soap") || endpoint.startsWith("axis")) {
            int i;
            MuleEndpointURI ep = new MuleEndpointURI(endpoint);
            QuickConfigurationBuilder builder = new QuickConfigurationBuilder();
            String serviceName = null;
            if (ep.getPath() != null) {
                String path = ep.getPath();
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if ((i = path.lastIndexOf("/")) > -1) {
                    serviceName = path.substring(i + 1);
                }
            } else {
                serviceName = this.descriptor.getName();
            }
            String newEndpoint = endpoint;
            i = newEndpoint.indexOf(serviceName);
            newEndpoint = newEndpoint.substring(0, i - 1);
            builder.registerComponentInstance(listener, serviceName, (UMOEndpointURI)new MuleEndpointURI(newEndpoint));
            return true;
        }
        return false;
    }

    protected void registerEndpointMappings() throws InitialisationException {
        if (this.endpointMappings != null) {
            Map.Entry entry = null;
            Iterator iterator = this.endpointMappings.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = iterator.next();
                MuleManager.getInstance().registerEndpointIdentifier((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    protected void registerConnectors() throws UMOException {
        Map connectors;
        if (!MuleManager.getInstance().isInitialised() && (connectors = this.applicationContext.getBeansOfType(UMOConnector.class, true, true)).size() > 0) {
            Iterator iterator = connectors.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                UMOConnector c = (UMOConnector)entry.getValue();
                if (c.getName() == null) {
                    c.setName(entry.getKey().toString());
                }
                MuleManager.getInstance().registerConnector(c);
            }
        }
    }

    protected void registerGlobalEndpoints() throws UMOException {
        Map endpoints;
        if (!MuleManager.getInstance().isInitialised() && (endpoints = this.applicationContext.getBeansOfType(UMOEndpoint.class, true, true)).size() > 0) {
            Iterator iterator = endpoints.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                UMOEndpoint endpoint = (UMOEndpoint)entry.getValue();
                if (endpoint.getName() == null) {
                    endpoint.setName(entry.getKey().toString());
                }
                MuleManager.getInstance().registerEndpoint(endpoint);
            }
        }
    }

    protected void registerTransformers() throws UMOException {
        Map transformers;
        if (!MuleManager.getInstance().isInitialised() && (transformers = this.applicationContext.getBeansOfType(UMOTransformer.class, true, true)).size() > 0) {
            Iterator iterator = transformers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                UMOTransformer t = (UMOTransformer)entry.getValue();
                if (t.getName() == null) {
                    t.setName(entry.getKey().toString());
                }
                MuleManager.getInstance().registerTransformer(t);
            }
        }
    }

    protected UMODescriptor getDefaultDescriptor() throws UMOException {
        UMODescriptor descriptor;
        UMOModel model = MuleManager.getInstance().lookupModel("_system");
        if (model == null) {
            model = new SedaModel();
            model.setName("_system");
            MuleManager.getInstance().registerModel(model);
        }
        if ((descriptor = model.getDescriptor(EVENT_MULTICASTER_DESCRIPTOR_NAME)) != null) {
            model.unregisterComponent(descriptor);
        }
        descriptor = new MuleDescriptor(EVENT_MULTICASTER_DESCRIPTOR_NAME);
        if (this.subscriptions == null) {
            logger.info((Object)"No receive endpoints have been set, using default '*'");
            descriptor.setInboundEndpoint((UMOEndpoint)new MuleEndpoint("vm://*", true));
        } else {
            UMOInboundRouterCollection messageRouter = descriptor.getInboundRouter();
            for (int i = 0; i < this.subscriptions.length; ++i) {
                String subscription = this.subscriptions[i];
                MuleEndpointURI endpointUri = new MuleEndpointURI(subscription);
                UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri((UMOEndpointURI)endpointUri, (String)"receiver");
                if (!this.asynchronous) {
                    endpoint.setSynchronous(true);
                }
                messageRouter.addEndpoint(endpoint);
            }
        }
        descriptor.setImplementation((Object)"applicationEventMulticaster");
        return descriptor;
    }

    protected ObjectFilter createFilter(String pattern) {
        try {
            if (this.getSubscriptionFilter() == null) {
                this.setSubscriptionFilter(WildcardFilter.class);
            }
            ObjectFilter filter = (ObjectFilter)ClassUtils.instanciateClass((Class)this.getSubscriptionFilter(), (Object[])new Object[]{pattern});
            return filter;
        }
        catch (Exception e) {
            this.exceptionListener.exceptionThrown(e);
            return new WildcardFilter(pattern);
        }
    }

    public Class getSubscriptionFilter() {
        return this.subscriptionFilter;
    }

    public void setSubscriptionFilter(Class subscriptionFilter) {
        this.subscriptionFilter = subscriptionFilter;
    }

    public Map getEndpointMappings() {
        return this.endpointMappings;
    }

    public void setEndpointMappings(Map endpointMappings) {
        this.endpointMappings = endpointMappings;
    }

    public String[] getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(String[] subscriptions) {
        this.subscriptions = subscriptions;
    }

    protected void setExceptionListener(ExceptionListener listener) {
        if (listener == null) {
            throw new NullPointerException("exceptionListener");
        }
        this.exceptionListener = listener;
    }

    public void destroy() throws Exception {
        MuleManager.getInstance().dispose();
    }

    private class LoggingExceptionListener
    implements ExceptionListener {
        private LoggingExceptionListener() {
        }

        public void exceptionThrown(Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

