/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.util.IOUtils;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;

public class MuleResourceLoader
extends DefaultResourceLoader
implements ResourcePatternResolver {
    protected transient Log logger = LogFactory.getLog((Class)MuleResourceLoader.class);

    public Resource getResource(String rsc) {
        return this.getResourceByPath(rsc);
    }

    protected Resource getResourceByPath(String path) {
        InputStream is = null;
        try {
            is = IOUtils.getResourceAsStream((String)path, ((Object)((Object)this)).getClass());
        }
        catch (IOException e) {
            this.logger.error((Object)("Unable to load Spring resource " + path + " : " + e.getMessage()));
            return null;
        }
        if (is != null) {
            return new InputStreamResource(is);
        }
        this.logger.error((Object)("Unable to locate Spring resource " + path));
        return null;
    }

    public Resource[] getResources(String rsc) throws IOException {
        if (rsc == null) {
            throw new IOException("No resources to read");
        }
        String[] resourcesNames = StringUtils.tokenizeToStringArray((String)rsc, (String)",;", (boolean)true, (boolean)true);
        Resource[] resources = new Resource[resourcesNames.length];
        for (int i = 0; i < resourcesNames.length; ++i) {
            resources[i] = this.getResourceByPath(resourcesNames[i]);
        }
        return resources;
    }
}

