/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.io.IOException;
import org.mule.MuleManager;
import org.mule.config.ConfigurationBuilder;
import org.mule.config.builders.MuleXmlConfigurationBuilder;
import org.mule.extras.spring.SpringContainerContext;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

public class MuleManagerBean
implements InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private Resource[] configResources;
    private SpringContainerContext containerContext;
    private UMOManager muleManager;
    private ConfigurationBuilder configurationBuilder;

    public void afterPropertiesSet() throws Exception {
        if (this.configurationBuilder == null) {
            this.configurationBuilder = new MuleXmlConfigurationBuilder();
        }
    }

    public void setConfigResources(Resource[] configResources) {
        this.configResources = configResources;
    }

    public void destroy() throws Exception {
        if (this.muleManager != null) {
            this.muleManager.dispose();
            this.muleManager = null;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.containerContext = new SpringContainerContext();
        this.containerContext.setBeanFactory((BeanFactory)applicationContext);
    }

    private UMOManager createMuleManager() throws Exception {
        UMOManager muleManager = MuleManager.getInstance();
        muleManager.setContainerContext((UMOContainerContext)this.containerContext);
        String configFilenames = this.getConfigFilenames();
        this.configurationBuilder.configure(configFilenames);
        return muleManager;
    }

    private String getConfigFilenames() {
        Object[] result = new String[this.configResources.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = this.configResources[i].getURL().getPath();
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return StringUtils.arrayToCommaDelimitedString((Object[])result);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.muleManager == null) {
            try {
                this.muleManager = this.createMuleManager();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public ConfigurationBuilder getConfigurationBuilder() {
        return this.configurationBuilder;
    }

    public void setConfigurationBuilder(ConfigurationBuilder configurationBuilder) {
        this.configurationBuilder = configurationBuilder;
    }
}

