/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring.config;

import java.beans.ExceptionListener;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.MuleConfiguration;
import org.mule.extras.spring.SpringContainerContext;
import org.mule.impl.model.ModelFactory;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.UMOInterceptorStack;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.UMOLifecycleAdapterFactory;
import org.mule.umo.manager.UMOAgent;
import org.mule.umo.manager.UMOContainerContext;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.manager.UMOTransactionManagerFactory;
import org.mule.umo.model.UMOEntryPointResolver;
import org.mule.umo.model.UMOModel;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.security.UMOSecurityManager;
import org.mule.umo.transformer.UMOTransformer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

public class AutowireUMOManagerFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware {
    protected static final Log logger = LogFactory.getLog((Class)AutowireUMOManagerFactoryBean.class);
    public static final String MULE_ENVIRONMENT_PROPERTIES_BEAN_NAME = "muleEnvironmentProperties";
    public static final String MULE_ENDPOINT_IDENTIFIERS_BEAN_NAME = "muleEndpointIdentifiers";
    public static final String MULE_INTERCEPTOR_STACK_BEAN_NAME = "muleInterceptorStacks";
    public static final String MULE_MODEL_EXCEPTION_STRATEGY_BEAN_NAME = "muleModelExceptionStrategy";
    private UMOManager manager = MuleManager.getInstance();
    private UMOModel model;
    private AbstractApplicationContext context;

    public Object getObject() throws Exception {
        return this.manager;
    }

    public Class getObjectType() {
        return UMOManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = (AbstractApplicationContext)applicationContext;
        try {
            Map temp = this.context.getBeansOfType(MuleConfiguration.class, true, true);
            if (temp.size() > 0) {
                MuleManager.setConfiguration((MuleConfiguration)((MuleConfiguration)temp.values().iterator().next()));
            }
            this.setProperties((Map)this.getBean(MULE_ENVIRONMENT_PROPERTIES_BEAN_NAME, Map.class));
            Map connectors = this.context.getBeansOfType(UMOConnector.class, true, true);
            this.setConnectors(connectors.values());
            this.setMessageEndpointIdentifiers((Map)this.getBean(MULE_ENDPOINT_IDENTIFIERS_BEAN_NAME, Map.class));
            temp = this.context.getBeansOfType(UMOTransactionManagerFactory.class, true, true);
            if (temp.size() > 0) {
                this.manager.setTransactionManager(((UMOTransactionManagerFactory)temp.values().iterator().next()).create());
            }
            if ((temp = this.context.getBeansOfType(UMOSecurityManager.class, true, true)).size() > 0) {
                this.manager.setSecurityManager((UMOSecurityManager)temp.values().iterator().next());
            }
            Map transformers = this.context.getBeansOfType(UMOTransformer.class, true, true);
            this.setTransformers(transformers.values());
            Map endpoints = this.context.getBeansOfType(UMOEndpoint.class, true, true);
            this.setEndpoints(endpoints.values());
            Map agents = this.context.getBeansOfType(UMOAgent.class, true, true);
            this.setAgents(agents.values());
            Map containers = this.context.getBeansOfType(UMOContainerContext.class, true, true);
            this.setContainerContext(containers);
            Map interceptors = this.context.getBeansOfType(UMOInterceptorStack.class, true, true);
            this.setInterceptorStacks(interceptors);
            this.createModel();
            Map components = this.context.getBeansOfType(UMODescriptor.class, true, true);
            this.setComponents(components.values());
        }
        catch (Exception e) {
            throw new BeanInitializationException("Failed to wire MuleManager together: " + e.getMessage(), (Throwable)e);
        }
    }

    public void setManagerId(String managerId) {
        this.manager.setId(managerId);
    }

    protected void createModel() throws UMOException {
        Object listener;
        Map lcaf;
        Map temp = this.context.getBeansOfType(UMOModel.class, true, true);
        if (temp.size() > 1) {
            throw new IllegalStateException("In Mule 1.x only one model can be created when using Spring");
        }
        if (temp.size() == 1) {
            Map.Entry entry = temp.entrySet().iterator().next();
            this.model = (UMOModel)entry.getValue();
            this.model.setName(entry.getKey().toString());
        } else {
            this.model = ModelFactory.createModel((String)MuleManager.getConfiguration().getModelType());
        }
        Map epr = this.context.getBeansOfType(UMOEntryPointResolver.class, true, true);
        if (epr.size() > 0) {
            this.model.setEntryPointResolver((UMOEntryPointResolver)epr.values().iterator().next());
        }
        if ((lcaf = this.context.getBeansOfType(UMOLifecycleAdapterFactory.class, true, true)).size() > 0) {
            this.model.setLifecycleAdapterFactory((UMOLifecycleAdapterFactory)lcaf.values().iterator().next());
        }
        if ((listener = this.getBean(MULE_MODEL_EXCEPTION_STRATEGY_BEAN_NAME, ExceptionListener.class)) != null) {
            this.model.setExceptionListener((ExceptionListener)listener);
        }
        this.manager.registerModel(this.model);
    }

    private Object getBean(String name, Class clazz) {
        try {
            return this.context.getBean(name, clazz);
        }
        catch (BeansException e) {
            return null;
        }
    }

    protected void setContainerContext(Map containers) throws UMOException {
        if (containers.size() == 0) {
            SpringContainerContext container = new SpringContainerContext();
            container.setBeanFactory((BeanFactory)this.context);
            this.manager.setContainerContext((UMOContainerContext)container);
        } else if (containers.size() == 1) {
            this.manager.setContainerContext((UMOContainerContext)containers.values().iterator().next());
        } else {
            UMOContainerContext ctx = (UMOContainerContext)containers.values().iterator().next();
            logger.warn((Object)("There are " + containers.size() + " container contexts in the spring context. Using the first one: " + ctx.getClass().getName()));
            this.manager.setContainerContext(ctx);
        }
    }

    protected void setMessageEndpointIdentifiers(Map endpoints) throws InitialisationException {
        if (endpoints == null) {
            return;
        }
        Iterator iterator = endpoints.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.manager.registerEndpointIdentifier(entry.getKey().toString(), entry.getValue().toString());
        }
    }

    protected void setAgents(Collection agents) throws UMOException {
        Iterator iterator = agents.iterator();
        while (iterator.hasNext()) {
            this.manager.registerAgent((UMOAgent)iterator.next());
        }
    }

    protected void setProperties(Map props) {
        if (props == null) {
            return;
        }
        Iterator iterator = props.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.manager.setProperty(entry.getKey(), entry.getValue());
        }
    }

    protected void setConnectors(Collection connectors) throws UMOException {
        Iterator iterator = connectors.iterator();
        while (iterator.hasNext()) {
            this.manager.registerConnector((UMOConnector)iterator.next());
        }
    }

    protected void setTransformers(Collection transformers) throws InitialisationException {
        Iterator iterator = transformers.iterator();
        while (iterator.hasNext()) {
            this.manager.registerTransformer((UMOTransformer)iterator.next());
        }
    }

    protected void setEndpoints(Collection endpoints) throws InitialisationException {
        Iterator iterator = endpoints.iterator();
        while (iterator.hasNext()) {
            this.manager.registerEndpoint((UMOEndpoint)iterator.next());
        }
    }

    protected void setComponents(Collection components) throws UMOException {
        Iterator iterator = components.iterator();
        while (iterator.hasNext()) {
            UMODescriptor d = (UMODescriptor)iterator.next();
            if (this.model.isComponentRegistered(d.getName())) continue;
            this.model.registerComponent(d);
        }
    }

    protected void setInterceptorStacks(Map stacks) {
        if (stacks == null) {
            return;
        }
        Iterator iterator = stacks.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String name = entry.getKey().toString();
            this.manager.registerInterceptorStack(name, (UMOInterceptorStack)entry.getValue());
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.manager.start();
    }

    public void destroy() throws Exception {
        this.manager.dispose();
    }
}

