/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extras.spring;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.mule.MuleManager;
import org.mule.config.ConfigurationException;
import org.mule.config.i18n.Message;
import org.mule.extras.spring.config.CachedResource;
import org.mule.extras.spring.config.ReaderInputStream;
import org.mule.impl.container.AbstractContainerContext;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.ContainerException;
import org.mule.umo.manager.ObjectNotFoundException;
import org.mule.util.ClassUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringContainerContext
extends AbstractContainerContext
implements BeanFactoryAware {
    public static final String SPRING_DOCTYPE_REF = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE beans PUBLIC \"-//SPRING//DTD BEAN//EN\" \"http://www.springframework.org/dtd/spring-beans.dtd\">\n";
    protected BeanFactory beanFactory;
    protected BeanFactory externalBeanFactory;
    protected String configFile;
    protected String configuration = null;

    public SpringContainerContext() {
        super("spring");
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setExternalBeanFactory(BeanFactory factory) {
        this.externalBeanFactory = factory;
    }

    public BeanFactory getBeanFactory() {
        if (this.externalBeanFactory != null) {
            return this.externalBeanFactory;
        }
        return this.beanFactory;
    }

    public Object getComponent(Object key) throws ObjectNotFoundException {
        if (this.getBeanFactory() == null) {
            throw new IllegalStateException("Spring Application context has not been set");
        }
        if (key == null) {
            throw new ObjectNotFoundException("Component not found for null key");
        }
        if (key instanceof Class) {
            throw new ObjectNotFoundException("The container is unable to build single instance of " + ((Class)key).getName() + " number of instances found was: 0");
        }
        try {
            return this.getBeanFactory().getBean(key.toString());
        }
        catch (BeansException e) {
            throw new ObjectNotFoundException("Component not found for key: " + key.toString(), (Throwable)e);
        }
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) throws ConfigurationException {
        this.configFile = configFile;
    }

    public void configure(Reader configuration) throws ContainerException {
        XmlBeanFactory bf = new XmlBeanFactory((Resource)new InputStreamResource((InputStream)new ReaderInputStream(configuration)));
        this.setExternalBeanFactory((BeanFactory)bf);
    }

    public void configure(String configurationXmlAsString) throws ContainerException {
        String encoding = MuleManager.getConfiguration().getEncoding();
        try {
            XmlBeanFactory bf = new XmlBeanFactory((Resource)new CachedResource(configurationXmlAsString, encoding));
            this.setExternalBeanFactory((BeanFactory)bf);
        }
        catch (UnsupportedEncodingException e) {
            Message message = new Message("core", 188, (Object)encoding);
            throw new ContainerException(message, (Throwable)e);
        }
    }

    public void initialise() throws InitialisationException {
        if (this.configFile == null) {
            if (this.configuration != null) {
                try {
                    this.configure(this.configuration);
                    return;
                }
                catch (ContainerException e) {
                    throw new InitialisationException((Throwable)e, (Object)this);
                }
            }
            return;
        }
        try {
            if (ClassUtils.getResource((String)this.configFile, ((Object)((Object)this)).getClass()) == null) {
                this.logger.warn((Object)("Spring config resource: " + this.configFile + " not found on class path, attempting to load it from local file"));
                this.setExternalBeanFactory((BeanFactory)new FileSystemXmlApplicationContext(this.configFile));
            } else {
                this.logger.info((Object)("Loading Spring config from classpath, resource is: " + this.configFile));
                this.setExternalBeanFactory((BeanFactory)new ClassPathXmlApplicationContext(this.configFile));
            }
        }
        catch (BeansException e) {
            throw new InitialisationException((Throwable)new ConfigurationException(new Message(58, (Object)("Application Context: " + this.configFile)), (Throwable)e), (Object)this);
        }
    }

    public void dispose() {
        if (this.externalBeanFactory instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)this.externalBeanFactory).close();
        }
        super.dispose();
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }
}

