/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security.filters.http;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.transport.PropertyScope;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.transport.http.filters.HttpBasicAuthenticationFilter;

public class HttpBasicAuthenticationFilterTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testAuthenticationHeaderFailure() throws Exception {
        MuleEvent oldEvent = RequestContext.getEvent();
        MuleEvent event = HttpBasicAuthenticationFilterTestCase.getTestEvent((Object)"a");
        MuleMessage message = event.getMessage();
        message.setProperty("Authorization", (Object)"Basic a", PropertyScope.INBOUND);
        RequestContext.setEvent((MuleEvent)event);
        HttpBasicAuthenticationFilter filter = new HttpBasicAuthenticationFilter();
        SecurityManager manager = (SecurityManager)Mockito.mock(SecurityManager.class);
        filter.setSecurityManager(manager);
        ((SecurityManager)Mockito.doThrow((Throwable)new UnauthorisedException(null, (MuleEvent)null)).when((Object)manager)).authenticate((Authentication)Matchers.anyObject());
        try {
            filter.authenticateInbound(event);
            Assert.fail((String)"An UnauthorisedException should be thrown");
        }
        catch (UnauthorisedException e) {
            Assert.assertNotNull((Object)event.getMessage().getProperty("WWW-Authenticate"));
            Assert.assertEquals((Object)"Basic realm=", (Object)event.getMessage().getProperty("WWW-Authenticate"));
            Mockito.verify((Object)manager);
        }
        RequestContext.setEvent((MuleEvent)oldEvent);
    }
}

