/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class PlainTextFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    public PlainTextFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "encryption-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "encryption-test-flow.xml"});
    }

    @Test
    public void testAuthenticationFailureNoContext() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage m = client.send("http://localhost:4567/index.html", (Object)"", null);
        Assert.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)401L, (long)status);
    }

    @Test
    public void testAuthenticationFailureBadCredentials() throws Exception {
        MuleClient client = new MuleClient("anonX", "anonX");
        MuleMessage m = client.send("http://localhost:4567/index.html", (Object)"", null);
        Assert.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)401L, (long)status);
    }

    @Test
    public void testAuthenticationAuthorised() throws Exception {
        MuleClient client = new MuleClient("anon", "anon");
        MuleMessage m = client.send("http://localhost:4567/index.html", (Object)"", null);
        Assert.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)200L, (long)status);
    }
}

