/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleMessage;
import org.mule.api.security.CredentialsNotSetException;
import org.mule.api.security.CryptoFailureException;
import org.mule.security.MuleCredentials;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class EncryptionFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    public EncryptionFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "encryption-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "encryption-test-flow.xml"});
    }

    @Test
    public void testAuthenticationFailureNoContext() throws Exception {
        MuleMessage result = muleContext.getClient().send("vm://my.queue", (Object)"foo", null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(CredentialsNotSetException.class, result.getExceptionPayload().getException().getClass());
    }

    @Test
    public void testAuthenticationFailureBadCredentials() throws Exception {
        Map<String, Object> props = this.createMessagePropertiesWithCredentials("anonX", "anonX");
        MuleMessage result = muleContext.getClient().send("vm://my.queue", (Object)"foo", null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertEquals(CredentialsNotSetException.class, result.getExceptionPayload().getException().getClass());
    }

    @Test
    public void testAuthenticationAuthorised() throws Exception {
        Map<String, Object> props = this.createMessagePropertiesWithCredentials("anon", "anon");
        MuleMessage m = muleContext.getClient().send("vm://my.queue", (Object)"foo", props);
        Assert.assertNotNull((Object)m);
        Assert.assertNull((Object)m.getExceptionPayload());
    }

    @Test
    public void testAuthenticationFailureBadCredentialsHttp() throws Exception {
        Map<String, Object> props = this.createMessagePropertiesWithCredentials("anonX", "anonX");
        MuleMessage m = muleContext.getClient().send("http://localhost:4567/index.html", (Object)"", props);
        Assert.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)401L, (long)status);
    }

    @Test
    public void testAuthenticationAuthorisedHttp() throws Exception {
        Map<String, Object> props = this.createMessagePropertiesWithCredentials("anon", "anon");
        MuleMessage m = muleContext.getClient().send("http://localhost:4567/index.html", (Object)"", props);
        Assert.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        Assert.assertEquals((long)200L, (long)status);
    }

    private Map<String, Object> createMessagePropertiesWithCredentials(String username, String password) throws CryptoFailureException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)username, (String)password, (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        return props;
    }
}

