/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.security.UnauthorisedException;
import org.mule.client.DefaultLocalMuleClient;
import org.mule.tck.junit4.FunctionalTestCase;

public class AuthenticateVmTransportTest
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "auth-vm-transport-config.xml";
    }

    @Test
    public void testExplicitAttributes() throws Exception {
        this.testVM("vm://test");
    }

    @Test
    public void testDefaultAttributes() throws Exception {
        this.testVM("vm://default-attributes");
    }

    protected void testVM(String endpoint) throws Exception {
        DefaultLocalMuleClient client = new DefaultLocalMuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("username", "ross");
        props.put("password", "ross");
        MuleMessage result = client.send(endpoint, (Object)"hi", props);
        Assert.assertNull((Object)result.getExceptionPayload());
        props.put("password", "badpass");
        MuleMessage result2 = client.send(endpoint, (Object)"hi", props);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotNull((Object)result2.getExceptionPayload());
        Assert.assertEquals(UnauthorisedException.class, result2.getExceptionPayload().getException().getClass());
    }
}

