/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.junit.Assert;
import org.junit.Test;
import org.mule.tck.junit4.FunctionalTestCase;

public class AuthorizationFilterTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "http-filter-test.xml";
    }

    @Test
    public void testAuthenticatedButNotAuthorized() throws Exception {
        this.doRequest(null, "localhost", "anon", "anon", this.getUrl(), false, 405);
    }

    @Test
    public void testAuthorized() throws Exception {
        this.doRequest(null, "localhost", "ross", "ross", this.getUrl(), false, 200);
    }

    protected String getUrl() {
        return "http://localhost:4567/authorize";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String realm, String host, String user, String pass, String url, boolean handshake, int result) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(handshake);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status == 401 && handshake && (status = client.executeMethod((HttpMethod)get)) == 401 && handshake) {
                status = client.executeMethod((HttpMethod)get);
            }
            Assert.assertEquals((long)result, (long)status);
        }
        finally {
            get.releaseConnection();
        }
    }
}

