/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Arrays;
import java.util.Collection;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class AuthenticationAgainstMultipleProvidersTestCase
extends AbstractServiceAndFlowTestCase {
    public AuthenticationAgainstMultipleProvidersTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "mule-multiple-providers-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "mule-multiple-providers-config-flow.xml"});
    }

    @Test
    public void testProvider1() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin1", "admin1");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:4445");
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
    }

    @Test
    public void testProvider2() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:4446");
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin", "admin");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
    }

    @Test
    public void testMultipleProviders() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin1", "admin1");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:4447");
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)401L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        Assert.assertEquals((long)200L, (long)httpClient.executeMethod((HttpMethod)postMethod));
        Assert.assertEquals((Object)"hello", (Object)postMethod.getResponseBodyAsString());
    }
}

