/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security.filters.http;

import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.RequestContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.security.Authentication;
import org.mule.api.security.SecurityManager;
import org.mule.api.security.UnauthorisedException;
import org.mule.api.transport.PropertyScope;
import org.mule.module.spring.security.filters.http.HttpBasicAuthenticationFilter;
import org.mule.tck.AbstractMuleTestCase;

public class HttpBasicAuthenticationFilterTestCase
extends AbstractMuleTestCase {
    public void testAuthenticationHeaderFailure() throws Exception {
        MuleEvent oldEvent = RequestContext.getEvent();
        MuleEvent event = HttpBasicAuthenticationFilterTestCase.getTestEvent((Object)"a");
        MuleMessage message = event.getMessage();
        message.setProperty("Authorization", (Object)"Basic a", PropertyScope.INBOUND);
        RequestContext.setEvent((MuleEvent)event);
        HttpBasicAuthenticationFilter filter = new HttpBasicAuthenticationFilter();
        SecurityManager manager = (SecurityManager)Mockito.mock(SecurityManager.class);
        filter.setSecurityManager(manager);
        ((SecurityManager)Mockito.doThrow((Throwable)new UnauthorisedException(null, (MuleEvent)null)).when((Object)manager)).authenticate((Authentication)Matchers.anyObject());
        try {
            filter.authenticateInbound(event);
            HttpBasicAuthenticationFilterTestCase.fail((String)"An UnauthorisedException should be thrown");
        }
        catch (UnauthorisedException e) {
            HttpBasicAuthenticationFilterTestCase.assertNotNull((Object)event.getMessage().getProperty("WWW-Authenticate"));
            HttpBasicAuthenticationFilterTestCase.assertEquals((Object)"Basic realm=", (Object)event.getMessage().getProperty("WWW-Authenticate"));
            Mockito.verify((Object)manager);
        }
        RequestContext.setEvent((MuleEvent)oldEvent);
    }
}

