/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import org.mule.api.MuleMessage;
import org.mule.api.context.notification.SecurityNotificationListener;
import org.mule.api.context.notification.ServerNotificationListener;
import org.mule.context.notification.SecurityNotification;
import org.mule.module.client.MuleClient;
import org.mule.tck.FunctionalTestCase;
import org.mule.util.concurrent.Latch;

public class SecureHttpPollingFunctionalTestCase
extends FunctionalTestCase {
    public void testPollingHttpConnectorSentCredentials() throws Exception {
        final Latch latch = new Latch();
        muleContext.registerListener((ServerNotificationListener)new SecurityNotificationListener<SecurityNotification>(){

            public void onNotification(SecurityNotification notification) {
                latch.countDown();
            }
        });
        MuleClient client = new MuleClient(muleContext);
        MuleMessage result = client.request("vm://toclient", 5000L);
        SecureHttpPollingFunctionalTestCase.assertNotNull((Object)result);
        SecureHttpPollingFunctionalTestCase.assertEquals((String)"foo", (String)result.getPayloadAsString());
        result = client.request("vm://toclient2", 1000L);
        SecureHttpPollingFunctionalTestCase.assertNotNull((Object)result);
        int status = (Integer)result.getInboundProperty("http.status", (Object)0);
        SecureHttpPollingFunctionalTestCase.assertEquals((int)401, (int)status);
        SecureHttpPollingFunctionalTestCase.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
    }

    protected String getConfigResources() {
        return "secure-http-polling-server.xml,secure-http-polling-client.xml";
    }
}

