/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.mule.tck.FunctionalTestCase;

public class HttpFilterFunctionalTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "http-filter-test.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAuthenticationFailureNoContext() throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        GetMethod get = new GetMethod(this.getUrl());
        get.setDoAuthentication(false);
        try {
            int status = client.executeMethod((HttpMethod)get);
            HttpFilterFunctionalTestCase.assertEquals((int)401, (int)status);
            HttpFilterFunctionalTestCase.assertTrue((boolean)get.getResponseBodyAsString().contains("no security context on the session. Authentication denied on endpoint"));
        }
        finally {
            get.releaseConnection();
        }
    }

    public void testAuthenticationFailureBadCredentials() throws Exception {
        this.doRequest(null, "localhost", "anonX", "anonX", this.getUrl(), true, false, 401);
    }

    protected String getUrl() {
        return "http://localhost:4567/index.html";
    }

    public void testAuthenticationAuthorised() throws Exception {
        this.doRequest(null, "localhost", "anon", "anon", this.getUrl(), false, true, 200);
    }

    public void testAuthenticationAuthorisedWithHandshake() throws Exception {
        this.doRequest(null, "localhost", "anon", "anon", this.getUrl(), true, false, 200);
    }

    public void testAuthenticationAuthorisedWithHandshakeAndBadRealm() throws Exception {
        this.doRequest("blah", "localhost", "anon", "anon", this.getUrl(), true, false, 401);
    }

    public void testAuthenticationAuthorisedWithHandshakeAndRealm() throws Exception {
        this.doRequest("mule-realm", "localhost", "ross", "ross", this.getUrl(), true, false, 200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String realm, String host, String user, String pass, String url, boolean handshake, boolean preemtive, int result) throws Exception {
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(preemtive);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(handshake);
        try {
            int status = client.executeMethod((HttpMethod)get);
            HttpFilterFunctionalTestCase.assertEquals((int)result, (int)status);
        }
        finally {
            get.releaseConnection();
        }
    }
}

