/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.HashMap;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleMessage;
import org.mule.api.security.CredentialsNotSetException;
import org.mule.api.security.UnauthorisedException;
import org.mule.config.ExceptionHelper;
import org.mule.module.client.MuleClient;
import org.mule.security.MuleCredentials;
import org.mule.tck.FunctionalTestCase;

public class EncryptionFunctionalTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "encryption-test.xml";
    }

    public void testAuthenticationFailureNoContext() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        MuleMessage m = client.send("vm://my.queue", (Object)"foo", null);
        EncryptionFunctionalTestCase.assertNotNull((Object)m);
        EncryptionFunctionalTestCase.assertNotNull((Object)m.getExceptionPayload());
        EncryptionFunctionalTestCase.assertEquals((int)ExceptionHelper.getErrorCode(CredentialsNotSetException.class), (int)m.getExceptionPayload().getCode());
    }

    public void testAuthenticationFailureBadCredentials() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anonX", (String)"anonX", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        MuleMessage m = client.send("vm://my.queue", (Object)"foo", props);
        EncryptionFunctionalTestCase.assertNotNull((Object)m);
        EncryptionFunctionalTestCase.assertNotNull((Object)m.getExceptionPayload());
        EncryptionFunctionalTestCase.assertEquals((int)ExceptionHelper.getErrorCode(UnauthorisedException.class), (int)m.getExceptionPayload().getCode());
    }

    public void testAuthenticationAuthorised() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anon", (String)"anon", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        MuleMessage m = client.send("vm://my.queue", (Object)"foo", props);
        EncryptionFunctionalTestCase.assertNotNull((Object)m);
        EncryptionFunctionalTestCase.assertNull((Object)m.getExceptionPayload());
    }

    public void testAuthenticationFailureBadCredentialsHttp() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anonX", (String)"anonX", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        MuleMessage m = client.send("http://localhost:4567/index.html", (Object)"", props);
        EncryptionFunctionalTestCase.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        EncryptionFunctionalTestCase.assertEquals((int)401, (int)status);
    }

    public void testAuthenticationAuthorisedHttp() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anon", (String)"anon", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        MuleMessage m = client.send("http://localhost:4567/index.html", (Object)"", props);
        EncryptionFunctionalTestCase.assertNotNull((Object)m);
        int status = (Integer)m.getInboundProperty("http.status", (Object)-1);
        EncryptionFunctionalTestCase.assertEquals((int)200, (int)status);
    }
}

