/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.Collection;
import java.util.Iterator;
import org.mule.api.endpoint.ImmutableEndpoint;
import org.mule.api.security.SecurityProvider;
import org.mule.api.service.Service;
import org.mule.module.spring.security.PreAuthenticatedAuthenticationProvider;
import org.mule.module.spring.security.SpringProviderAdapter;
import org.mule.module.spring.security.UserAndPasswordAuthenticationProvider;
import org.mule.module.spring.security.filters.http.HttpBasicAuthenticationFilter;
import org.mule.security.MuleSecurityManager;
import org.mule.service.ServiceCompositeMessageSource;
import org.mule.tck.FunctionalTestCase;

public class AuthenticationNamespaceHandlerTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "authentication-config.xml";
    }

    public void testSecurityManagerConfigured() {
        MuleSecurityManager securityManager = (MuleSecurityManager)muleContext.getRegistry().lookupObject("_muleSecurityManager");
        AuthenticationNamespaceHandlerTestCase.assertNotNull((Object)securityManager);
        Collection providers = securityManager.getProviders();
        AuthenticationNamespaceHandlerTestCase.assertEquals((int)2, (int)providers.size());
        Iterator providersIterator = providers.iterator();
        SecurityProvider provider = (SecurityProvider)providersIterator.next();
        AuthenticationNamespaceHandlerTestCase.assertEquals(SpringProviderAdapter.class, provider.getClass());
        AuthenticationNamespaceHandlerTestCase.assertEquals(UserAndPasswordAuthenticationProvider.class, ((SpringProviderAdapter)provider).getAuthenticationProvider().getClass());
        provider = (SecurityProvider)providersIterator.next();
        AuthenticationNamespaceHandlerTestCase.assertEquals(SpringProviderAdapter.class, provider.getClass());
        AuthenticationNamespaceHandlerTestCase.assertEquals(PreAuthenticatedAuthenticationProvider.class, ((SpringProviderAdapter)provider).getAuthenticationProvider().getClass());
    }

    public void testEndpointConfiguration() {
        Service service = muleContext.getRegistry().lookupService("echo");
        AuthenticationNamespaceHandlerTestCase.assertNotNull((Object)service);
        AuthenticationNamespaceHandlerTestCase.assertEquals((int)1, (int)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().size());
        ImmutableEndpoint endpoint = (ImmutableEndpoint)((ServiceCompositeMessageSource)service.getMessageSource()).getEndpoints().get(0);
        AuthenticationNamespaceHandlerTestCase.assertNotNull((Object)endpoint.getSecurityFilter());
        AuthenticationNamespaceHandlerTestCase.assertEquals(HttpBasicAuthenticationFilter.class, endpoint.getSecurityFilter().getClass());
    }
}

