/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.mule.tck.FunctionalTestCase;

public class AuthenticationAgainstMultipleProvidersTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "mule-multiple-providers-config.xml";
    }

    public void testProvider1() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin1", "admin1");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:4445");
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)200, (int)httpClient.executeMethod((HttpMethod)postMethod));
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((String)"hello", (String)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)401, (int)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)401, (int)httpClient.executeMethod((HttpMethod)postMethod));
    }

    public void testProvider2() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:4446");
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)200, (int)httpClient.executeMethod((HttpMethod)postMethod));
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((String)"hello", (String)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)401, (int)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin", "admin");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)401, (int)httpClient.executeMethod((HttpMethod)postMethod));
    }

    public void testMultipleProviders() throws Exception {
        HttpClient httpClient = new HttpClient();
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials("admin1", "admin1");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        httpClient.getParams().setAuthenticationPreemptive(true);
        PostMethod postMethod = new PostMethod("http://localhost:4447");
        postMethod.setDoAuthentication(true);
        postMethod.setRequestEntity((RequestEntity)new StringRequestEntity("hello", "text/html", "UTF-8"));
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)200, (int)httpClient.executeMethod((HttpMethod)postMethod));
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((String)"hello", (String)postMethod.getResponseBodyAsString());
        credentials = new UsernamePasswordCredentials("asdf", "asdf");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)401, (int)httpClient.executeMethod((HttpMethod)postMethod));
        credentials = new UsernamePasswordCredentials("admin2", "admin2");
        httpClient.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((int)200, (int)httpClient.executeMethod((HttpMethod)postMethod));
        AuthenticationAgainstMultipleProvidersTestCase.assertEquals((String)"hello", (String)postMethod.getResponseBodyAsString());
    }
}

