/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.HashMap;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.security.MuleCredentials;
import org.mule.tck.FunctionalTestCase;
import org.mule.transport.NullPayload;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class AuthComponentSynchFunctionalTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "auth-component-synch-test.xml";
    }

    public void doTearDown() {
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl());
    }

    public void testCaseGoodAuthenticationGoodAuthorisation() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"marie", (String)"marie", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        MuleMessage m = client.send("vm://test", (Object)"Marie", props);
        AuthComponentSynchFunctionalTestCase.assertNotNull((Object)m);
        AuthComponentSynchFunctionalTestCase.assertTrue((boolean)m.getPayload().equals("Marie"));
    }

    public void testCaseGoodAuthenticationBadAuthorisation() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anon", (String)"anon", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        MuleMessage m = client.send("vm://test", (Object)"Marie", props);
        AuthComponentSynchFunctionalTestCase.assertEquals((Object)NullPayload.getInstance(), (Object)m.getPayload());
    }

    public void testCaseBadAuthentication() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anonX", (String)"anonX", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        MuleMessage m = client.send("vm://test", (Object)"Marie", props);
        AuthComponentSynchFunctionalTestCase.assertNotNull((Object)m.getPayload());
    }
}

