/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.security;

import java.util.HashMap;
import org.mule.api.EncryptionStrategy;
import org.mule.api.MuleMessage;
import org.mule.module.client.MuleClient;
import org.mule.security.MuleCredentials;
import org.mule.tck.FunctionalTestCase;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

public class AuthComponentAsynchFunctionalTestCase
extends FunctionalTestCase {
    protected String getConfigResources() {
        return "auth-component-asynch-test.xml";
    }

    public void doTearDown() {
        SecurityContextHolder.setContext((SecurityContext)new SecurityContextImpl());
    }

    public void testCaseGoodAuthenticationGoodAuthorisation() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"marie", (String)"marie", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        client.dispatch("vm://test", (Object)"Marie", props);
        MuleMessage m = client.request("vm://output", 3000L);
        AuthComponentAsynchFunctionalTestCase.assertNotNull((Object)m);
        AuthComponentAsynchFunctionalTestCase.assertEquals((String)((String)m.getPayload()), (String)"Marie");
    }

    public void testCaseGoodAuthenticationBadAuthorisation() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anon", (String)"anon", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        client.dispatch("vm://test", (Object)"Marie", props);
        MuleMessage m = client.request("vm://output", 3000L);
        AuthComponentAsynchFunctionalTestCase.assertNull((Object)m);
    }

    public void testCaseBadAuthentication() throws Exception {
        MuleClient client = new MuleClient(muleContext);
        HashMap<String, String> props = new HashMap<String, String>();
        EncryptionStrategy strategy = muleContext.getSecurityManager().getEncryptionStrategy("PBE");
        String header = MuleCredentials.createHeader((String)"anonX", (String)"anonX", (String)"PBE", (EncryptionStrategy)strategy);
        props.put("MULE_USER", header);
        client.dispatch("vm://test", (Object)"USD,MTL", props);
        MuleMessage m = client.request("vm://output", 3000L);
        AuthComponentAsynchFunctionalTestCase.assertNull((Object)m);
    }
}

