/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.remoting;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.module.spring.remoting.ComplexData;
import org.mule.module.spring.remoting.WorkInterface;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

public class SpringRemotingTestCase
extends AbstractServiceAndFlowTestCase {
    private static final String SPRING_HTTP_ENDPOINT = "http://localhost:8003/springService";

    public SpringRemotingTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "spring-remoting-mule-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "spring-remoting-mule-config-flow.xml"});
    }

    @Test
    public void testHttpInvokeSpringService() throws Exception {
        ComplexData cd = new ComplexData("Foo", new Integer(13));
        HttpInvokerProxyFactoryBean invoker = new HttpInvokerProxyFactoryBean();
        invoker.setServiceInterface(WorkInterface.class);
        invoker.setServiceUrl(SPRING_HTTP_ENDPOINT);
        invoker.afterPropertiesSet();
        WorkInterface worker = (WorkInterface)invoker.getObject();
        ComplexData data = worker.executeComplexity(cd);
        Assert.assertNotNull((Object)data);
        Assert.assertEquals((Object)data.getSomeString(), (Object)"Foo Received");
        Assert.assertEquals((Object)data.getSomeInteger(), (Object)new Integer(14));
    }
}

