/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.spring.events;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEventContext;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.transformer.Transformer;
import org.mule.module.client.MuleClient;
import org.mule.module.spring.events.MuleApplicationEvent;
import org.mule.module.spring.events.MuleEventMulticaster;
import org.mule.module.spring.events.TestAllEventBean;
import org.mule.module.spring.events.TestApplicationEventBean;
import org.mule.module.spring.events.TestMuleEventBean;
import org.mule.module.spring.events.TestSubscriptionEventBean;
import org.mule.tck.functional.EventCallback;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.transformer.AbstractMessageTransformer;
import org.mule.util.ExceptionUtils;
import org.mule.util.concurrent.Latch;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class SpringEventsTestCase
extends FunctionalTestCase {
    protected static final int DEFAULT_LATCH_TIMEOUT = 10000;
    private static final int NUMBER_OF_MESSAGES = 10;
    volatile AtomicInteger eventCounter1;
    volatile AtomicInteger eventCounter2;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.eventCounter1 = new AtomicInteger(0);
        this.eventCounter2 = new AtomicInteger(0);
    }

    protected String getConfigResources() {
        return "mule-events-app-context.xml";
    }

    @Test
    public void testManagerIsInstanciated() throws Exception {
        Assert.assertTrue((boolean)muleContext.isInitialised());
        Assert.assertTrue((boolean)muleContext.isStarted());
        Assert.assertNotNull((Object)muleContext.getRegistry().lookupObject("applicationEventMulticaster"));
    }

    @Test
    public void testRemovingListeners() throws Exception {
        TestSubscriptionEventBean subscriptionBean = (TestSubscriptionEventBean)muleContext.getRegistry().lookupObject("testSubscribingEventBean1");
        Assert.assertNotNull((Object)subscriptionBean);
        MuleEventMulticaster multicaster = (MuleEventMulticaster)muleContext.getRegistry().lookupObject("applicationEventMulticaster");
        Assert.assertNotNull((Object)multicaster);
        Latch whenFinished = new Latch();
        subscriptionBean.setEventCallback(new CountingEventCallback(this.eventCounter1, 1, (CountDownLatch)whenFinished));
        multicaster.removeApplicationListener((ApplicationListener)subscriptionBean);
        MuleClient client = new MuleClient(muleContext);
        client.send("vm://event.multicaster", (Object)"Test Spring MuleEvent", null);
        Assert.assertEquals((long)0L, (long)this.eventCounter1.get());
        multicaster.addApplicationListener((ApplicationListener)subscriptionBean);
        client.send("vm://event.multicaster", (Object)"Test Spring MuleEvent", null);
        Assert.assertTrue((boolean)whenFinished.await(10000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)1L, (long)this.eventCounter1.get());
        this.eventCounter1.set(0);
        multicaster.removeAllListeners();
        client.send("vm://event.multicaster", (Object)"Test Spring MuleEvent", null);
        Assert.assertEquals((long)0L, (long)this.eventCounter1.get());
        multicaster.addApplicationListener((ApplicationListener)subscriptionBean);
        subscriptionBean.setEventCallback(null);
    }

    @Test
    public void testReceivingANonSubscriptionMuleEvent() throws Exception {
        TestMuleEventBean bean = (TestMuleEventBean)muleContext.getRegistry().lookupObject("testNonSubscribingMuleEventBean");
        Assert.assertNotNull((Object)bean);
        Latch whenFinished = new Latch();
        bean.setEventCallback(new CountingEventCallback(this.eventCounter1, 1, (CountDownLatch)whenFinished));
        MuleClient client = new MuleClient(muleContext);
        client.send("vm://event.multicaster", (Object)"Test Spring MuleEvent", null);
        whenFinished.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.eventCounter1.get());
    }

    @Test
    public void testReceivingASpringEvent() throws Exception {
        TestApplicationEventBean bean = (TestApplicationEventBean)muleContext.getRegistry().lookupObject("testEventSpringBean");
        Assert.assertNotNull((Object)bean);
        final Latch whenFinished = new Latch();
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object o) throws Exception {
                Assert.assertNull((Object)context);
                if (o instanceof TestApplicationEvent && SpringEventsTestCase.this.eventCounter1.incrementAndGet() == 1) {
                    whenFinished.countDown();
                }
            }
        };
        bean.setEventCallback(callback);
        ApplicationContext context = ((MuleEventMulticaster)SpringEventsTestCase.muleContext.getRegistry().lookupObject((String)"applicationEventMulticaster")).applicationContext;
        context.publishEvent((ApplicationEvent)new TestApplicationEvent(context));
        whenFinished.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.eventCounter1.get());
    }

    @Test
    public void testReceivingAllEvents() throws Exception {
        TestAllEventBean bean = (TestAllEventBean)muleContext.getRegistry().lookupObject("testAllEventBean");
        Assert.assertNotNull((Object)bean);
        Latch whenFinished = new Latch();
        bean.setEventCallback(new CountingEventCallback(this.eventCounter1, 2, (CountDownLatch)whenFinished));
        MuleClient client = new MuleClient(muleContext);
        client.send("vm://event.multicaster", (Object)"Test Spring MuleEvent", null);
        ApplicationContext context = ((MuleEventMulticaster)SpringEventsTestCase.muleContext.getRegistry().lookupObject((String)"applicationEventMulticaster")).applicationContext;
        context.publishEvent((ApplicationEvent)new TestApplicationEvent(context));
        whenFinished.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)2L, (long)this.eventCounter1.get());
    }

    @Test
    public void testReceivingASubscriptionEvent() throws Exception {
        TestSubscriptionEventBean subscriptionBean = (TestSubscriptionEventBean)muleContext.getRegistry().lookupObject("testSubscribingEventBean1");
        Assert.assertNotNull((Object)subscriptionBean);
        Latch whenFinished = new Latch();
        subscriptionBean.setEventCallback(new CountingEventCallback(this.eventCounter1, 1, (CountDownLatch)whenFinished));
        MuleClient client = new MuleClient(muleContext);
        client.send("vm://event.multicaster", (Object)"Test Spring MuleEvent", null);
        whenFinished.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)1L, (long)this.eventCounter1.get());
    }

    @Test
    public void testReceiveAndPublishEvent() throws Exception {
        TestSubscriptionEventBean bean1 = (TestSubscriptionEventBean)muleContext.getRegistry().lookupObject("testSubscribingEventBean1");
        Assert.assertNotNull((Object)bean1);
        final Latch whenFinished1 = new Latch();
        EventCallback callback = new EventCallback(){

            public void eventReceived(MuleEventContext context, Object o) throws Exception {
                MuleApplicationEvent returnEvent = new MuleApplicationEvent((Object)"MuleEvent from a spring bean", "vm://testBean2");
                MuleApplicationEvent e = (MuleApplicationEvent)o;
                e.getApplicationContext().publishEvent((ApplicationEvent)returnEvent);
                if (SpringEventsTestCase.this.eventCounter1.incrementAndGet() == 10) {
                    whenFinished1.countDown();
                }
            }
        };
        bean1.setEventCallback(callback);
        TestSubscriptionEventBean bean2 = (TestSubscriptionEventBean)muleContext.getRegistry().lookupObject("testSubscribingEventBean2");
        Assert.assertNotNull((Object)bean2);
        Latch whenFinished2 = new Latch();
        bean2.setEventCallback(new CountingEventCallback(this.eventCounter2, 10, (CountDownLatch)whenFinished2));
        this.doSend("vm://event.multicaster", "Test Spring MuleEvent", 10);
        whenFinished1.await(10000L, TimeUnit.MILLISECONDS);
        whenFinished2.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)10L, (long)this.eventCounter1.get());
        Assert.assertEquals((long)10L, (long)this.eventCounter2.get());
    }

    @Test
    public void testPublishOnly() throws Exception {
        MuleApplicationEvent event = new MuleApplicationEvent((Object)"MuleEvent from a spring bean", "vm://testBean2");
        TestSubscriptionEventBean bean2 = (TestSubscriptionEventBean)muleContext.getRegistry().lookupObject("testSubscribingEventBean2");
        Assert.assertNotNull((Object)bean2);
        Latch whenFinished = new Latch();
        bean2.setEventCallback(new CountingEventCallback(this.eventCounter1, 10, (CountDownLatch)whenFinished));
        this.doPublish((ApplicationEvent)event, 10);
        whenFinished.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((long)10L, (long)this.eventCounter1.get());
    }

    @Test
    public void testPublishWithEventAwareTransformer() throws Exception {
        CountDownLatch transformerLatch = new CountDownLatch(1);
        TestEventAwareTransformer trans = new TestEventAwareTransformer();
        trans.setLatch(transformerLatch);
        muleContext.getRegistry().registerTransformer((Transformer)trans);
        MuleApplicationEvent event = new MuleApplicationEvent((Object)"MuleEvent from a spring bean", "vm://testBean2?transformers=dummyTransformer");
        TestSubscriptionEventBean bean2 = (TestSubscriptionEventBean)muleContext.getRegistry().lookupObject("testSubscribingEventBean2");
        Assert.assertNotNull((Object)bean2);
        Latch whenFinished = new Latch();
        bean2.setEventCallback(new CountingEventCallback(this.eventCounter1, 1, (CountDownLatch)whenFinished));
        this.doPublish((ApplicationEvent)event, 1);
        whenFinished.await(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)transformerLatch.await(10000L, TimeUnit.MILLISECONDS));
        Assert.assertEquals((long)1L, (long)this.eventCounter1.get());
    }

    protected void doPublish(final ApplicationEvent event, final int count) {
        Runnable publisher = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < count; ++i) {
                    ApplicationContext context = null;
                    try {
                        context = ((MuleEventMulticaster)muleContext.getRegistry().lookupObject((String)"applicationEventMulticaster")).applicationContext;
                        context.publishEvent(event);
                        continue;
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                        continue;
                    }
                    catch (SecurityException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        Executors.newSingleThreadExecutor().execute(publisher);
    }

    protected void doSend(final String url, final Object payload, final int count) {
        Runnable sender = new Runnable(){

            @Override
            public void run() {
                try {
                    MuleClient client = new MuleClient(muleContext);
                    for (int i = 0; i < count; ++i) {
                        client.send(url, payload, null);
                    }
                }
                catch (MuleException ex) {
                    Assert.fail((String)ExceptionUtils.getStackTrace((Throwable)ex));
                }
            }
        };
        Executors.newSingleThreadExecutor().execute(sender);
    }

    public static class TestApplicationEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1L;

        public TestApplicationEvent(Object source) {
            super(source);
        }
    }

    public static class TestEventAwareTransformer
    extends AbstractMessageTransformer {
        private CountDownLatch latch;

        public TestEventAwareTransformer() {
            this.setName("dummyTransformer");
        }

        public Object clone() throws CloneNotSupportedException {
            TestEventAwareTransformer clone = (TestEventAwareTransformer)((Object)super.clone());
            clone.setLatch(this.latch);
            return clone;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public Object transformMessage(MuleMessage message, String outputEncoding) {
            Assert.assertNotNull((Object)message);
            if (this.latch != null) {
                this.latch.countDown();
            }
            return message;
        }
    }

    public static class CountingEventCallback
    implements EventCallback {
        private final AtomicInteger counter;
        private final int maxCount;
        private final CountDownLatch finished;

        public CountingEventCallback(AtomicInteger counter, int maxCount, CountDownLatch whenFinished) {
            this.counter = counter;
            this.maxCount = maxCount;
            this.finished = whenFinished;
        }

        public void eventReceived(MuleEventContext context, Object o) throws Exception {
            if (!(o instanceof ContextRefreshedEvent) && this.counter.incrementAndGet() == this.maxCount && this.finished != null) {
                this.finished.countDown();
            }
        }
    }
}

