/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.filter;

import javax.script.Bindings;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.LifecycleUtils;
import org.mule.api.routing.filter.Filter;
import org.mule.module.scripting.component.Scriptable;
import org.mule.processor.AbstractFilteringMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptFilter
extends AbstractFilteringMessageProcessor
implements Filter,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptFilter.class);
    private Scriptable script;
    private String name;

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded((Object)this.script, (MuleContext)this.muleContext);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.script, (Logger)LOGGER);
    }

    protected boolean accept(MuleEvent event) {
        return this.accept(event.getMessage());
    }

    public boolean accept(MuleMessage message) {
        Bindings bindings = this.script.getScriptEngine().createBindings();
        this.script.populateBindings(bindings, message);
        try {
            return (Boolean)this.script.runScript(bindings);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public Scriptable getScript() {
        return this.script;
    }

    public void setScript(Scriptable script) {
        this.script = script;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

