/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.transformer;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class GroovyScriptTransformerFunctionalTestCase
extends AbstractServiceAndFlowTestCase {
    public GroovyScriptTransformerFunctionalTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
        this.setDisposeContextPerClass(false);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "groovy-transformer-config-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "groovy-transformer-config-flow.xml"});
    }

    @Test
    public void testInlineScript() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in1", (Object)"hello", null);
        MuleMessage response = client.request("vm://out1", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"hexxo", (Object)response.getPayload());
    }

    @Test
    public void testFileBasedScript() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in2", (Object)"hello", null);
        MuleMessage response = client.request("vm://out2", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"hexxo", (Object)response.getPayload());
    }

    @Test
    public void testReferencedTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in3", (Object)"hello", null);
        MuleMessage response = client.request("vm://out3", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"hexxo", (Object)response.getPayload());
    }

    @Test
    public void testReferencedTransformerWithParameters() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.dispatch("vm://in4", (Object)"hello", null);
        MuleMessage response = client.request("vm://out4", 5000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"hexxo", (Object)response.getPayload());
    }

    @Test
    public void transformByAssigningPayload() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in5", (Object)"hello", null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"bar", (Object)response.getPayload());
    }

    @Test
    public void transformByAssigningHeader() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://in6", (Object)"hello", null);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"hello", (Object)response.getPayload());
        Assert.assertEquals((Object)"bar", (Object)response.getInboundProperty("foo"));
    }
}

