/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting.expression;

import groovyjarjarasm.asm.ClassWriter;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.ExceptionPayload;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.MuleRuntimeException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.expression.ExpressionEvaluator;
import org.mule.api.expression.ExpressionManager;
import org.mule.config.i18n.CoreMessages;
import org.mule.message.DefaultExceptionPayload;
import org.mule.module.scripting.expression.GroovyExpressionEvaluator;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.testmodels.fruit.Apple;
import org.mule.tck.testmodels.fruit.Banana;
import org.mule.tck.testmodels.fruit.FruitBowl;

public class GroovyExpressionEvaluatorTestCase
extends AbstractMuleContextTestCase {
    @Test
    public void testWithExpressions() {
        FruitBowl payload = this.createFruitBowl();
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)payload, muleContext);
        GroovyExpressionEvaluator e = new GroovyExpressionEvaluator();
        e.setMuleContext(muleContext);
        Object value = e.evaluate("payload.apple.washed", (MuleMessage)msg);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)value));
        value = e.evaluate("message.payload.banana.bitten", (MuleMessage)msg);
        Assert.assertNotNull((Object)value);
        Assert.assertTrue((boolean)(value instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)value));
    }

    @Test
    public void stringToPrimitiveIntTypeConversion() {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)"1", muleContext);
        GroovyExpressionEvaluator e = new GroovyExpressionEvaluator();
        e.setMuleContext(muleContext);
        Object value = e.evaluate("(payload as int) > 0", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)value));
        Object value2 = e.evaluate("(payload as int) > 1", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value2 instanceof Boolean));
        Assert.assertFalse((boolean)((Boolean)value2));
        Object value3 = e.evaluate("(payload as int) == 1", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value3 instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)value3));
    }

    @Test
    public void longNumberTypeConversion() {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)new Long("1"), muleContext);
        GroovyExpressionEvaluator e = new GroovyExpressionEvaluator();
        e.setMuleContext(muleContext);
        Object value = e.evaluate("payload > 0", (MuleMessage)msg);
        assert (value instanceof Boolean);
        Assert.assertTrue((boolean)((Boolean)value));
        Object value2 = e.evaluate("payload > 1", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value2 instanceof Boolean));
        Assert.assertFalse((boolean)((Boolean)value2));
        Object value3 = e.evaluate("payload == 1", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value3 instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)value3));
    }

    @Test
    public void primitiveLongNumberTypeConversion() {
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)Long.parseLong("1"), muleContext);
        GroovyExpressionEvaluator e = new GroovyExpressionEvaluator();
        e.setMuleContext(muleContext);
        Object value = e.evaluate("payload > 0", (MuleMessage)msg);
        assert (value instanceof Boolean);
        Assert.assertTrue((boolean)((Boolean)value));
        Object value2 = e.evaluate("payload > 1", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value2 instanceof Boolean));
        Assert.assertFalse((boolean)((Boolean)value2));
        Object value3 = e.evaluate("payload == 1", (MuleMessage)msg);
        Assert.assertTrue((boolean)(value3 instanceof Boolean));
        Assert.assertTrue((boolean)((Boolean)value3));
    }

    @Test(expected=MuleRuntimeException.class)
    public void testThrowsExceptionOnScriptError() throws Exception {
        FruitBowl payload = this.createFruitBowl();
        DefaultMuleMessage msg = new DefaultMuleMessage((Object)payload, muleContext);
        GroovyExpressionEvaluator e = new GroovyExpressionEvaluator();
        e.setMuleContext(muleContext);
        e.evaluate("unexistent", (MuleMessage)msg);
    }

    @Test
    public void testRegistrySyntax() throws Exception {
        Apple apple = new Apple();
        muleContext.getRegistry().registerObject("name.with.dots", (Object)apple);
        Object result = this.evaluate("#[groovy:registry.lookupObject('name.with.dots')]");
        Assert.assertNotNull((Object)result);
        Assert.assertSame((Object)apple, (Object)result);
        result = this.evaluate("#[groovy:registry.'name.with.dots']");
        Assert.assertNotNull((Object)result);
        Assert.assertSame((Object)apple, (Object)result);
        result = this.evaluate("#[groovy:registry['name.with.dots']]");
        Assert.assertNotNull((Object)result);
        Assert.assertSame((Object)apple, (Object)result);
        result = this.evaluate("#[groovy:registry.'name.with.dots'.washed]");
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)false, (Object)result);
    }

    private Object evaluate(String expression) {
        ExpressionManager expressionManager = muleContext.getExpressionManager();
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        return expressionManager.evaluate(expression, event);
    }

    @Test
    public void muleContext() throws Exception {
        Object result = this.evaluate("#[groovy:muleContext]");
        Assert.assertSame((Object)muleContext, (Object)result);
    }

    @Test
    public void message() throws Exception {
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Assert.assertSame((Object)mockMessage, (Object)muleContext.getExpressionManager().evaluate("#[groovy:message]", mockMessage));
    }

    @Test
    public void payload() throws Exception {
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Object payload = new Object();
        Mockito.when((Object)mockMessage.getPayload()).thenReturn(payload);
        Assert.assertSame((Object)payload, (Object)muleContext.getExpressionManager().evaluate("#[groovy:payload]", mockMessage));
    }

    @Test
    public void src() throws Exception {
        MuleMessage mockMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Object payload = new Object();
        Mockito.when((Object)mockMessage.getPayload()).thenReturn(payload);
        Assert.assertSame((Object)payload, (Object)muleContext.getExpressionManager().evaluate("#[groovy:src]", mockMessage));
    }

    @Test
    public void variableFromFlowScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar");
        event.setSessionVariable("foo", (Object)"NOTbar");
        Assert.assertEquals((Object)event.getFlowVariable("foo"), (Object)muleContext.getExpressionManager().evaluate("#[groovy:foo]", (MuleMessage)message));
    }

    @Test
    public void variableFromSessionScope() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setSessionVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)event.getSessionVariable("foo"), (Object)muleContext.getExpressionManager().evaluate("#[groovy:foo]", (MuleMessage)message));
    }

    @Test
    public void assignValueToVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar_old");
        muleContext.getExpressionManager().evaluate("#[groovy:foo='bar']", (MuleMessage)message);
        Assert.assertEquals((Object)"bar_old", (Object)event.getFlowVariable("foo"));
    }

    @Test
    public void assignValueToNewVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        muleContext.getExpressionManager().evaluate("#[groovy:foo='bar']", (MuleMessage)message);
        Assert.assertNull((Object)event.getFlowVariable("foo"));
    }

    @Test
    public void flowVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)event.getFlowVariable("foo"), (Object)muleContext.getExpressionManager().evaluate("#[groovy:flowVars['foo']]", (MuleEvent)event));
    }

    @Test
    public void assignValueToFlowVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setFlowVariable("foo", (Object)"bar_old");
        muleContext.getExpressionManager().evaluate("#[groovy:flowVars['foo']='bar']", (MuleEvent)event);
        Assert.assertEquals((Object)"bar", (Object)event.getFlowVariable("foo"));
    }

    @Test
    public void assignValueToNewFlowVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        muleContext.getExpressionManager().evaluate("#[groovy:flowVars['foo']='bar']", (MuleEvent)event);
        Assert.assertEquals((Object)"bar", (Object)event.getFlowVariable("foo"));
    }

    @Test
    public void sessionVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setSessionVariable("foo", (Object)"bar");
        Assert.assertEquals((Object)event.getSessionVariable("foo"), (Object)muleContext.getExpressionManager().evaluate("#[groovy:sessionVars['foo']]", (MuleEvent)event));
    }

    @Test
    public void assignValueToSessionVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        event.setSessionVariable("foo", (Object)"bar_old");
        muleContext.getExpressionManager().evaluate("#[groovy:sessionVars['foo']='bar']", (MuleEvent)event);
        Assert.assertEquals((Object)"bar", (Object)event.getSessionVariable("foo"));
    }

    @Test
    public void assignValueToNewSessionVariable() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        DefaultMuleEvent event = new DefaultMuleEvent((MuleMessage)message, MessageExchangePattern.ONE_WAY, (FlowConstruct)Mockito.mock(FlowConstruct.class));
        muleContext.getExpressionManager().evaluate("#[groovy:sessionVars['foo']='bar']", (MuleEvent)event);
        Assert.assertEquals((Object)"bar", (Object)event.getSessionVariable("foo"));
    }

    @Test
    public void exception() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        RuntimeException rte = new RuntimeException();
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)rte));
        Assert.assertEquals((Object)rte, (Object)muleContext.getExpressionManager().evaluate("#[groovy:exception]", (MuleMessage)message));
    }

    @Test
    public void muleException() throws Exception {
        DefaultMuleMessage message = new DefaultMuleMessage((Object)"", muleContext);
        RuntimeException rte = new RuntimeException();
        MessagingException me = new MessagingException(CoreMessages.version(), (MuleMessage)message, (Throwable)rte);
        message.setExceptionPayload((ExceptionPayload)new DefaultExceptionPayload((Throwable)me));
        Assert.assertEquals((Object)me, (Object)muleContext.getExpressionManager().evaluate("#[groovy:exception]", (MuleMessage)message));
    }

    @Test
    public void testComplexExpressionLowLevelParsing() throws Exception {
        GroovyExpressionEvaluator evaluator = new GroovyExpressionEvaluator();
        evaluator.setMuleContext(muleContext);
        muleContext.getExpressionManager().registerEvaluator((ExpressionEvaluator)evaluator);
        DefaultMuleMessage msg = new DefaultMuleMessage(Arrays.asList(0, "test"), muleContext);
        String result = muleContext.getExpressionManager().parse("#[groovy:payload[0]] - #[groovy:payload[1].toUpperCase()]", (MuleMessage)msg);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((String)"Expressions didn't evaluate correctly", (Object)"0 - TEST", (Object)result);
    }

    @Test
    public void testUseContextClassLoaderToResolveClasses() throws ClassNotFoundException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(new MyClassClassLoader());
            Assert.assertFalse((boolean)((Boolean)muleContext.getExpressionManager().evaluate("groovy:payload instanceof MyClass", (MuleMessage)new DefaultMuleMessage((Object)"test", muleContext))));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private FruitBowl createFruitBowl() {
        Apple apple = new Apple();
        apple.wash();
        Banana banana = new Banana();
        banana.bite();
        return new FruitBowl(apple, banana);
    }

    class MyClassClassLoader
    extends ClassLoader {
        MyClassClassLoader() {
        }

        @Override
        protected Class<?> findClass(String className) throws ClassNotFoundException {
            if (className.equals("MyClass")) {
                ClassWriter cw = new ClassWriter(2);
                cw.visit(49, 1, "MyClass", null, "java/lang/Object", null);
                return this.defineClass(className, cw.toByteArray(), 0, cw.toByteArray().length);
            }
            return super.findClass(className);
        }
    }
}

