/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=Parameterized.class)
public class ScriptEnginePresenceTestCase
extends AbstractMuleTestCase {
    @Parameterized.Parameter(value=0)
    public String engineName;
    @Parameterized.Parameter(value=1)
    public String extension;
    @Parameterized.Parameter(value=2)
    public String fullName;
    @Parameterized.Parameter(value=3)
    public String version;
    private ScriptEngineManager scriptEngineManager;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"groovy", "groovy", "Groovy Scripting Engine", "2.0"}, {"jython", "py", "jython", "2.7.3"}, {"jruby", "rb", "JSR 223 JRuby Engine", "1.7.27"}, {"rhino", "js", "Mozilla Rhino", "1.6R5"}, {"rhino", "js", "Mozilla Rhino", "1.6 release 2"});
    }

    @Before
    public void before() {
        this.scriptEngineManager = new ScriptEngineManager();
    }

    @Test
    public void allEngines() {
        List<ScriptEngineFactory> engineFactories = this.scriptEngineManager.getEngineFactories();
        for (ScriptEngineFactory scriptEngineFactory : engineFactories) {
            scriptEngineFactory.getScriptEngine();
        }
        Assert.assertThat(engineFactories, (Matcher)CoreMatchers.hasItem((Matcher)new TypeSafeMatcher<ScriptEngineFactory>(){

            public void describeTo(Description description) {
                description.appendText("expected '" + ScriptEnginePresenceTestCase.this.fullName + " " + ScriptEnginePresenceTestCase.this.version + "'");
            }

            protected void describeMismatchSafely(ScriptEngineFactory item, Description mismatchDescription) {
                mismatchDescription.appendText("was ").appendValue((Object)("'" + item.getEngineName() + " " + item.getEngineVersion() + "'"));
            }

            protected boolean matchesSafely(ScriptEngineFactory item) {
                return ScriptEnginePresenceTestCase.this.fullName.equals(item.getEngineName()) && ScriptEnginePresenceTestCase.this.version.equals(item.getEngineVersion());
            }
        }));
    }

    @Test
    public void findEngineByName() throws Exception {
        Assert.assertThat((Object)this.scriptEngineManager.getEngineByName(this.engineName), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void findEngineByExtension() throws Exception {
        Assert.assertThat((Object)this.scriptEngineManager.getEngineByExtension(this.extension), (Matcher)CoreMatchers.notNullValue());
    }
}

