/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.scripting;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.tck.junit4.FunctionalTestCase;

public class GreedyTestCase
extends FunctionalTestCase {
    protected String getConfigFile() {
        return "greedy-config.xml";
    }

    @Test
    public void testDollars() throws Exception {
        this.runTest(2.33, "USD", "[9 quarters, 0 dimes, 1 nickels, 3 pennies]");
    }

    @Test
    public void testPounds() throws Exception {
        this.runTest(1.28, "GBP", "[1 pounds, 1 twenty_pence, 1 five_pence, 1 two_pence, 1 pennies]");
    }

    private void runTest(double amount, String currency, String expectedResult) throws Exception {
        MuleEvent event = GreedyTestCase.getTestEvent((Object)(amount * 100.0));
        event.setFlowVariable("currency", (Object)currency);
        MuleEvent response = this.runFlow("greedy", event);
        Assert.assertThat((Object)response.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)expectedResult));
    }
}

