/*
 * Decompiled with CFR 0.152.
 */
package org.mule.components.script.refreshable;

import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.util.IOUtils;

public abstract class AbstractRefreshableBeanTestCase
extends AbstractServiceAndFlowTestCase {
    protected static final int WAIT_TIME = 1000;

    public AbstractRefreshableBeanTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    protected void writeScript(String src, String path) throws IOException {
        FileWriter scriptFile = new FileWriter(path, false);
        scriptFile.write(src);
        scriptFile.flush();
        scriptFile.close();
    }

    protected String nameToPath(String name) {
        URL url = IOUtils.getResourceAsUrl((String)name, ((Object)((Object)this)).getClass());
        String path = url.getFile();
        this.logger.info((Object)(url + " -> " + path));
        return path;
    }

    protected void runScriptTest(String script, String name, String endpoint, String payload, String result) throws Exception {
        this.writeScript(script, this.nameToPath(name));
        Thread.sleep(1000L);
        LocalMuleClient client = muleContext.getClient();
        MuleMessage m = client.send(endpoint, (Object)payload, null);
        Assert.assertNotNull((Object)m);
        Assert.assertEquals((Object)(payload + result), (Object)m.getPayloadAsString());
    }
}

