/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jbpm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.bpm.BPMS;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class VariablesComponentTestCase
extends AbstractServiceAndFlowTestCase {
    private final int TIMEOUT = 10000;

    public VariablesComponentTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jbpm-component-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jbpm-component-functional-test-flow.xml"});
    }

    @Test
    public void testVariables() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        BPMS bpms = (BPMS)muleContext.getRegistry().lookupObject(BPMS.class);
        Assert.assertNotNull((Object)bpms);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("foo", "bar");
        MuleMessage response = client.send("vm://variables", (Object)"data", props);
        String processId = (String)bpms.getId(response.getPayload());
        Assert.assertNotNull((Object)processId);
        response = client.request("vm://queueA", 10000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"bar", (Object)response.getInboundProperty("foo"));
        Assert.assertEquals((Object)0.75, (Object)response.getInboundProperty("fraction"));
        props = new HashMap();
        props.put("MULE_BPM_PROCESS_ID", processId);
        props.put("straw", "berry");
        props.put("time", new Date());
        response = client.send("vm://variables", (Object)"data", props);
        response = client.request("vm://queueB", 10000L);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)"bar", (Object)response.getInboundProperty("foo"));
        Assert.assertEquals((Object)0.75, (Object)response.getInboundProperty("fraction"));
        Assert.assertEquals((Object)"berry", (Object)response.getInboundProperty("straw"));
        Object o = response.getInboundProperty("time");
        Assert.assertTrue((boolean)(o instanceof Date));
    }
}

