/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jbpm;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.bpm.BPMS;
import org.mule.tck.AbstractServiceAndFlowTestCase;

public class SimpleJbpmComponentTestCase
extends AbstractServiceAndFlowTestCase {
    public SimpleJbpmComponentTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jbpm-component-functional-test-service.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jbpm-component-functional-test-flow.xml"});
    }

    @Test
    public void testSimpleProcess() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        BPMS bpms = (BPMS)muleContext.getRegistry().lookupObject(BPMS.class);
        Assert.assertNotNull((Object)bpms);
        MuleMessage response = client.send("vm://simple", (Object)"data", null);
        Object process = response.getPayload();
        String processId = (String)bpms.getId(process);
        Assert.assertFalse((processId == null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"dummyState", (Object)bpms.getState(process));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("MULE_BPM_PROCESS_ID", processId);
        response = client.send("vm://simple", null, props);
        process = response.getPayload();
        Assert.assertTrue((boolean)bpms.hasEnded(process));
    }
}

