/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jbpm;

import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.api.transformer.TransformerException;
import org.mule.tck.AbstractServiceAndFlowTestCase;
import org.mule.tck.exceptions.FunctionalTestException;
import org.mule.util.ExceptionUtils;

public class MessagingExceptionComponentTestCase
extends AbstractServiceAndFlowTestCase {
    public MessagingExceptionComponentTestCase(AbstractServiceAndFlowTestCase.ConfigVariant variant, String configResources) {
        super(variant, configResources);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({AbstractServiceAndFlowTestCase.ConfigVariant.SERVICE, "jbpm-component-functional-test-flow.xml"}, {AbstractServiceAndFlowTestCase.ConfigVariant.FLOW, "jbpm-component-functional-test-service.xml"});
    }

    @Test
    public void testNoException() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        client.send("vm://exception", (Object)"testNoException", null);
        Assert.assertNotNull((Object)client.request("vm://queueC", 1000L));
        Assert.assertNotNull((Object)client.request("vm://queueD", 1000L));
    }

    @Test
    public void testExceptionInService() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://exception", (Object)"testExceptionInService", null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertTrue((boolean)(ExceptionUtils.getRootCause((Throwable)result.getExceptionPayload().getException()) instanceof FunctionalTestException));
        Assert.assertNotNull((Object)client.request("vm://queueC", 1000L));
        Assert.assertNull((Object)client.request("vm://queueD", 1000L));
    }

    @Test
    public void testExceptionInTransformer() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage result = client.send("vm://exception", (Object)"testExceptionInTransformer", null);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getExceptionPayload());
        Assert.assertTrue((boolean)(ExceptionUtils.getRootCause((Throwable)result.getExceptionPayload().getException()) instanceof TransformerException));
        Assert.assertNotNull((Object)client.request("vm://queueC", 1000L));
        Assert.assertNull((Object)client.request("vm://queueD", 1000L));
    }
}

