/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.domain.request;

import java.util.ArrayList;
import java.util.Collection;
import org.mule.module.http.internal.ParameterMap;
import org.mule.module.http.internal.domain.BaseHttpMessage;
import org.mule.module.http.internal.domain.HttpEntity;
import org.mule.module.http.internal.domain.HttpProtocol;
import org.mule.module.http.internal.domain.InputStreamHttpEntity;
import org.mule.module.http.internal.domain.request.HttpRequest;

public class DefaultHttpRequest
extends BaseHttpMessage
implements HttpRequest {
    private final String uri;
    private final String path;
    private final String method;
    private HttpProtocol version;
    private ParameterMap headers;
    private ParameterMap queryParams;
    private HttpEntity entity;

    DefaultHttpRequest(String uri, String path, String method, ParameterMap headers, ParameterMap queryParams, HttpEntity entity) {
        this.uri = uri;
        this.path = path;
        this.method = method;
        this.headers = headers;
        this.queryParams = queryParams;
        this.entity = entity;
    }

    @Override
    public HttpProtocol getProtocol() {
        return this.version;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public Collection<String> getHeaderNames() {
        if (this.headers == null) {
            return new ArrayList<String>();
        }
        return this.headers.keySet();
    }

    @Override
    public String getHeaderValue(String headerName) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.get(headerName);
    }

    @Override
    public Collection<String> getHeaderValues(String headerName) {
        return this.headers.getAll(headerName);
    }

    @Override
    public HttpEntity getEntity() {
        return this.entity;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public ParameterMap getQueryParams() {
        return this.queryParams;
    }

    @Override
    public InputStreamHttpEntity getInputStreamEntity() {
        return null;
    }
}

