/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.matcher;

import org.apache.http.HttpResponse;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class HttpResponseReasonPhraseMatcher
extends TypeSafeMatcher<HttpResponse> {
    private String reasonPhrase;

    public HttpResponseReasonPhraseMatcher(String reasonPhrase) {
        this.reasonPhrase = reasonPhrase;
    }

    public boolean matchesSafely(HttpResponse response) {
        return this.reasonPhrase.equals(response.getStatusLine().getReasonPhrase());
    }

    public void describeTo(Description description) {
        description.appendText("a response with reason phrase ").appendValue((Object)this.reasonPhrase);
    }

    protected void describeMismatchSafely(HttpResponse response, Description mismatchDescription) {
        mismatchDescription.appendText("got a response with reason phrase ").appendValue((Object)response.getStatusLine().getReasonPhrase());
    }

    @Factory
    public static Matcher<HttpResponse> hasReasonPhrase(String reasonPhrease) {
        return new HttpResponseReasonPhraseMatcher(reasonPhrease);
    }
}

