/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request.client;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Answers;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.client.OperationOptions;
import org.mule.api.client.SimpleOptionsBuilder;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.api.client.HttpRequestOptions;
import org.mule.module.http.api.client.HttpRequestOptionsBuilder;
import org.mule.module.http.api.requester.HttpRequesterConfig;
import org.mule.module.http.api.requester.HttpStreamingType;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.module.http.internal.request.client.HttpConnectorMessageProcessorProvider;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.ssl.api.TlsContextFactory;

@SmallTest
public class HttpConnectorMessageProcessorProviderTestCase
extends AbstractMuleTestCase {
    private static final String PATH_URL = "http://localhost:8080/path";
    private static final String ANOTHER_PATH = "http://localhost:8080/another";
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private DefaultHttpRequesterConfig mockRequestConfig = (DefaultHttpRequesterConfig)Mockito.mock(DefaultHttpRequesterConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private TlsContextFactory mockTlsContextFactory = (TlsContextFactory)Mockito.mock(TlsContextFactory.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private final HttpConnectorMessageProcessorProvider httpConnectorMessageProcessorProvider = new HttpConnectorMessageProcessorProvider();

    @Before
    public void setUpTest() {
        Mockito.when((Object)this.mockMuleContext.getRegistry().get("_muleDefaultHttpRequestConfig")).thenReturn((Object)this.mockRequestConfig);
        this.httpConnectorMessageProcessorProvider.setMuleContext(this.mockMuleContext);
    }

    @Test
    public void sameConfigReturnsSameInstanceUsingGenericOptions() throws Exception {
        MessageProcessor messageProcessor = this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, SimpleOptionsBuilder.newOptions().build(), MessageExchangePattern.REQUEST_RESPONSE);
        Assert.assertThat((Object)this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, SimpleOptionsBuilder.newOptions().build(), MessageExchangePattern.REQUEST_RESPONSE), (Matcher)Is.is((Object)messageProcessor));
    }

    @Test
    public void sameConfigReturnsSameInstanceUsingDifferentGenericOptions() throws Exception {
        MessageProcessor messageProcessor = this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, SimpleOptionsBuilder.newOptions().build(), MessageExchangePattern.REQUEST_RESPONSE);
        Assert.assertThat((Object)this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, ((SimpleOptionsBuilder)SimpleOptionsBuilder.newOptions().responseTimeout(1000L)).build(), MessageExchangePattern.REQUEST_RESPONSE), (Matcher)IsNot.not((Matcher)Is.is((Object)messageProcessor)));
    }

    @Test
    public void sameConfigReturnsSameInstanceUsingDifferentHttpOptions() throws Exception {
        MessageProcessor messageProcessor = this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)HttpRequestOptionsBuilder.newOptions().requestStreamingMode(HttpStreamingType.ALWAYS).build(), MessageExchangePattern.REQUEST_RESPONSE);
        Assert.assertThat((Object)this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)HttpRequestOptionsBuilder.newOptions().disableParseResponse().build(), MessageExchangePattern.REQUEST_RESPONSE), (Matcher)IsNot.not((Matcher)Is.is((Object)messageProcessor)));
    }

    @Test
    public void sameConfigReturnsSameInstanceUsingCompleteHttpOptionsWithConfig() throws Exception {
        HttpRequestOptions options = ((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().requestStreamingMode(HttpStreamingType.ALWAYS).disableFollowsRedirect().disableParseResponse().disableStatusCodeValidation().method(HttpConstants.Methods.POST.name()).requestConfig((HttpRequesterConfig)this.mockRequestConfig).responseTimeout(1000L)).build();
        this.assertSameConfigReturnsSameInstance(options);
    }

    @Test
    public void sameConfigReturnsSameInstanceUsingCompleteHttpOptionsWithTlsContext() throws Exception {
        Mockito.when((Object)this.mockMuleContext.getRegistry().get(Matchers.anyString())).thenReturn(null);
        HttpRequestOptions options = ((HttpRequestOptionsBuilder)HttpRequestOptionsBuilder.newOptions().requestStreamingMode(HttpStreamingType.ALWAYS).disableFollowsRedirect().disableParseResponse().disableStatusCodeValidation().method(HttpConstants.Methods.POST.name()).tlsContextFactory(this.mockTlsContextFactory).responseTimeout(1000L)).build();
        this.assertSameConfigReturnsSameInstance(options);
    }

    private void assertSameConfigReturnsSameInstance(HttpRequestOptions requestOptions) throws Exception {
        MessageProcessor messageProcessor = this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)requestOptions, MessageExchangePattern.REQUEST_RESPONSE);
        Assert.assertThat((Object)this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)requestOptions, MessageExchangePattern.REQUEST_RESPONSE), (Matcher)Is.is((Object)messageProcessor));
    }

    @Test
    public void differentPathReturnsDifferentOperations() throws Exception {
        MessageProcessor messageProcessor = this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)HttpRequestOptionsBuilder.newOptions().build(), MessageExchangePattern.ONE_WAY);
        Assert.assertThat((Object)this.httpConnectorMessageProcessorProvider.getMessageProcessor(ANOTHER_PATH, (OperationOptions)HttpRequestOptionsBuilder.newOptions().build(), MessageExchangePattern.ONE_WAY), (Matcher)IsNot.not((Matcher)Is.is((Object)messageProcessor)));
    }

    @Test
    public void differentExchangePatternsReturnsDifferentOperations() throws Exception {
        MessageProcessor messageProcessor = this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)HttpRequestOptionsBuilder.newOptions().build(), MessageExchangePattern.ONE_WAY);
        Assert.assertThat((Object)this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)HttpRequestOptionsBuilder.newOptions().build(), MessageExchangePattern.REQUEST_RESPONSE), (Matcher)IsNot.not((Matcher)Is.is((Object)messageProcessor)));
    }

    @Test
    public void disposeInvalidatesCache() throws Exception {
        MessageProcessor messageProcessor = this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, SimpleOptionsBuilder.newOptions().build(), MessageExchangePattern.REQUEST_RESPONSE);
        this.httpConnectorMessageProcessorProvider.dispose();
        Assert.assertThat((Object)this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, SimpleOptionsBuilder.newOptions().build(), MessageExchangePattern.REQUEST_RESPONSE), (Matcher)IsNot.not((Matcher)Is.is((Object)messageProcessor)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowNullUrl() throws Exception {
        this.httpConnectorMessageProcessorProvider.getMessageProcessor(null, (OperationOptions)HttpRequestOptionsBuilder.newOptions().build(), MessageExchangePattern.ONE_WAY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowNullOptions() throws Exception {
        this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, null, MessageExchangePattern.ONE_WAY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void doNotAllowNullExchangePattern() throws Exception {
        this.httpConnectorMessageProcessorProvider.getMessageProcessor(PATH_URL, (OperationOptions)HttpRequestOptionsBuilder.newOptions().build(), null);
    }
}

