/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.request;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.DefaultMuleEvent;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.construct.Flow;
import org.mule.module.http.api.HttpAuthentication;
import org.mule.module.http.api.requester.HttpSendBodyMode;
import org.mule.module.http.internal.HttpParamType;
import org.mule.module.http.internal.HttpSingleParam;
import org.mule.module.http.internal.domain.request.HttpRequestAuthentication;
import org.mule.module.http.internal.request.DefaultHttpAuthentication;
import org.mule.module.http.internal.request.DefaultHttpRequester;
import org.mule.module.http.internal.request.DefaultHttpRequesterConfig;
import org.mule.module.http.internal.request.HttpAuthenticationType;
import org.mule.module.http.internal.request.HttpRequesterRequestBuilder;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;

public class DefaultHttpRequesterDebugInfoTestCase
extends AbstractMuleContextTestCase {
    private static final String DOMAIN_PROPERTY = "domain";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String PREEMPTIVE_PROPERTY = "preemptive";
    private static final String USERNAME_PROPERTY = "username";
    private static final String WORKSTATION_PROPERTY = "workstation";
    private static final String HOST_PROPERTY = "host";
    private static final String PORT_PROPERTY = "port";
    private static final String METHOD_PROPERTY = "method";
    private static final String STREAMING_MODE_PROPERTY = "streamingMode";
    private static final String SEND_BODY_PROPERTY = "sendBody";
    private static final String FOLLOW_REDIRECTS_PROPERTY = "followRedirects";
    private static final String PARSE_RESPONSE_PROPERTY = "parseResponse";
    private static final String RESPONSE_TIMEOUT_PROPERTY = "responseTimeout";
    private static final String DOMAIN = "myDomain";
    private static final String PASSWORD = "myPassword";
    private static final String USERNAME = "myUsername";
    private static final String WORKSTATION = "myWorkstation";
    private static final int RESPONSE_TIMEOUT = 5000;
    private static final String HOST = "myHost";
    private static final String PORT = "7777";
    private static final String METHOD = "GET";
    public static final String PARAM_NAME1 = "paramName1";
    public static final String PARAM_NAME2 = "paramName2";
    public static final String PARAM2_SECOND_VALUE_PROPERTY = "paramName2_2";
    public static final String PARAM2_FIRST_VALUE_PROPERTY = "paramName2_1";
    public static final String PARAM_VALUE1 = "foo";
    public static final String PARAM_VALUE2 = "bar";
    private DefaultHttpRequester requester = new DefaultHttpRequester();
    private DefaultHttpRequesterConfig config = new DefaultHttpRequesterConfig();
    private DefaultMuleMessage message;
    private DefaultMuleEvent event;

    @Before
    public void setup() {
        this.requester.setMuleContext(muleContext);
        this.config.setMuleContext(muleContext);
        this.requester.setConfig(this.config);
        this.requester.setPath("/");
        this.requester.setRequestBuilder(this.createRequestBuilder());
        this.message = new DefaultMuleMessage((Object)"Test Message", muleContext);
        this.event = new DefaultMuleEvent((MuleMessage)this.message, MessageExchangePattern.REQUEST_RESPONSE, (FlowConstruct)Mockito.mock(Flow.class));
    }

    @Test
    public void returnsDebugInfoWithSecurity() throws Exception {
        this.configureSecurityExpressions();
        this.addConfigSecurityProperties(this.message);
        this.doDebugInfoTest(this.message, this.event, this.getSecurityFieldsMatchers());
    }

    @Test
    public void returnsDebugInfoWithoutSecurity() throws Exception {
        this.doDebugInfoTest(this.message, this.event, null);
    }

    private void doDebugInfoTest(DefaultMuleMessage message, DefaultMuleEvent event, List<Matcher<FieldDebugInfo<?>>> securityFieldMatchers) throws InitialisationException {
        this.configureRequesterExpressions();
        this.addRequesterProperties(message);
        List debugInfo = this.requester.getDebugInfo((MuleEvent)event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)9));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"URI", String.class, (Object)String.format("http://%s:%s/", HOST, PORT))));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Method", String.class, (Object)METHOD)));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Streaming Mode", Boolean.class, (Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Send Body", HttpSendBodyMode.class, (Object)HttpSendBodyMode.ALWAYS)));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Follow Redirects", Boolean.class, (Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Parse Response", Boolean.class, (Object)Boolean.TRUE)));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Response Timeout", Integer.class, (Object)5000)));
        ArrayList<Matcher> paramMatchers = new ArrayList<Matcher>();
        paramMatchers.add(FieldDebugInfoMatcher.fieldLike((String)PARAM_NAME1, String.class, (Object)PARAM_VALUE1));
        paramMatchers.add(FieldDebugInfoMatcher.fieldLike((String)PARAM_NAME2, List.class, (Matcher)Matchers.contains((Object[])new String[]{PARAM_VALUE1, PARAM_VALUE2})));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Query Params", List.class, paramMatchers)));
        if (securityFieldMatchers == null) {
            MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Security", HttpRequestAuthentication.class, (Object)org.mockito.Matchers.isNull())));
        } else {
            MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Security", HttpRequestAuthentication.class, securityFieldMatchers)));
        }
    }

    private List<Matcher<FieldDebugInfo<?>>> getSecurityFieldsMatchers() {
        ArrayList securityFields = new ArrayList();
        securityFields.add(FieldDebugInfoMatcher.fieldLike((String)"Username", String.class, (Object)USERNAME));
        securityFields.add(FieldDebugInfoMatcher.fieldLike((String)"Domain", String.class, (Object)DOMAIN));
        securityFields.add(FieldDebugInfoMatcher.fieldLike((String)"Password", String.class, (Object)PASSWORD));
        securityFields.add(FieldDebugInfoMatcher.fieldLike((String)"Workstation", String.class, (Object)WORKSTATION));
        securityFields.add(FieldDebugInfoMatcher.fieldLike((String)"Authentication Type", String.class, (Object)"BASIC"));
        return securityFields;
    }

    private void addConfigSecurityProperties(DefaultMuleMessage message) {
        message.setInvocationProperty(DOMAIN_PROPERTY, (Object)DOMAIN);
        message.setInvocationProperty(PASSWORD_PROPERTY, (Object)PASSWORD);
        message.setInvocationProperty(PREEMPTIVE_PROPERTY, (Object)Boolean.FALSE.toString());
        message.setInvocationProperty(USERNAME_PROPERTY, (Object)USERNAME);
        message.setInvocationProperty(WORKSTATION_PROPERTY, (Object)WORKSTATION);
    }

    private void addRequesterProperties(DefaultMuleMessage message) {
        message.setInvocationProperty(HOST_PROPERTY, (Object)HOST);
        message.setInvocationProperty(PORT_PROPERTY, (Object)PORT);
        message.setInvocationProperty(METHOD_PROPERTY, (Object)METHOD);
        message.setInvocationProperty(STREAMING_MODE_PROPERTY, (Object)Boolean.TRUE.toString());
        message.setInvocationProperty(SEND_BODY_PROPERTY, (Object)HttpSendBodyMode.ALWAYS.toString());
        message.setInvocationProperty(FOLLOW_REDIRECTS_PROPERTY, (Object)Boolean.TRUE.toString());
        message.setInvocationProperty(PARSE_RESPONSE_PROPERTY, (Object)Boolean.TRUE.toString());
        message.setInvocationProperty(RESPONSE_TIMEOUT_PROPERTY, (Object)5000);
        message.setInvocationProperty(PARAM_NAME1, (Object)PARAM_VALUE1);
        message.setInvocationProperty(PARAM2_FIRST_VALUE_PROPERTY, (Object)PARAM_VALUE1);
        message.setInvocationProperty(PARAM2_SECOND_VALUE_PROPERTY, (Object)PARAM_VALUE2);
    }

    private void configureSecurityExpressions() throws InitialisationException {
        DefaultHttpAuthentication authentication = new DefaultHttpAuthentication(HttpAuthenticationType.BASIC);
        authentication.setDomain(this.getExpression(DOMAIN_PROPERTY));
        authentication.setPassword(this.getExpression(PASSWORD_PROPERTY));
        authentication.setPreemptive(this.getExpression(PREEMPTIVE_PROPERTY));
        authentication.setUsername(this.getExpression(USERNAME_PROPERTY));
        authentication.setWorkstation(this.getExpression(WORKSTATION_PROPERTY));
        authentication.setMuleContext(muleContext);
        authentication.initialise();
        this.config.setAuthentication((HttpAuthentication)authentication);
    }

    private String getExpression(String name) {
        return String.format("#[%s]", name);
    }

    private void configureRequesterExpressions() throws InitialisationException {
        this.requester.setHost(this.getExpression(HOST_PROPERTY));
        this.requester.setPort(this.getExpression(PORT_PROPERTY));
        this.requester.setMethod(this.getExpression(METHOD_PROPERTY));
        this.requester.setRequestStreamingMode(this.getExpression(STREAMING_MODE_PROPERTY));
        this.requester.setSendBodyMode(this.getExpression(SEND_BODY_PROPERTY));
        this.requester.setFollowRedirects(this.getExpression(FOLLOW_REDIRECTS_PROPERTY));
        this.requester.setFollowRedirects(this.getExpression(PARSE_RESPONSE_PROPERTY));
        this.requester.setResponseTimeout(this.getExpression(RESPONSE_TIMEOUT_PROPERTY));
        this.requester.initialise();
    }

    private HttpRequesterRequestBuilder createRequestBuilder() {
        HttpRequesterRequestBuilder requestBuilder = new HttpRequesterRequestBuilder();
        ArrayList<HttpSingleParam> params = new ArrayList<HttpSingleParam>();
        params.add(this.createHttpParam(PARAM_NAME1, this.getExpression(PARAM_NAME1)));
        params.add(this.createHttpParam(PARAM_NAME2, this.getExpression(PARAM2_FIRST_VALUE_PROPERTY)));
        params.add(this.createHttpParam(PARAM_NAME2, this.getExpression(PARAM2_SECOND_VALUE_PROPERTY)));
        requestBuilder.setParams(params);
        return requestBuilder;
    }

    private HttpSingleParam createHttpParam(String name, String value) {
        HttpSingleParam httpSingleParam = new HttpSingleParam(HttpParamType.QUERY_PARAM);
        httpSingleParam.setName(name);
        httpSingleParam.setValue(value);
        httpSingleParam.setMuleContext(muleContext);
        return httpSingleParam;
    }
}

