/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener.matcher;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.http.internal.domain.request.HttpRequestBuilder;
import org.mule.module.http.internal.listener.matcher.MethodRequestMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MethodRequestMatcherTestCase
extends AbstractMuleTestCase {
    @Test(expected=IllegalArgumentException.class)
    public void doNotAcceptsNull() {
        new MethodRequestMatcher(null);
    }

    @Test
    public void onlyAcceptsOneMethod() {
        MethodRequestMatcher matcher = new MethodRequestMatcher(new String[]{"GET"});
        Assert.assertThat((Object)matcher.matches(new HttpRequestBuilder().setMethod("GET").build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(new HttpRequestBuilder().setMethod("POST").build()), (Matcher)Is.is((Object)false));
    }

    @Test
    public void acceptSeveralMethods() {
        MethodRequestMatcher matcher = new MethodRequestMatcher(new String[]{"GET", "POST", "PATCH"});
        Assert.assertThat((Object)matcher.matches(new HttpRequestBuilder().setMethod("GET").build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(new HttpRequestBuilder().setMethod("POST").build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(new HttpRequestBuilder().setMethod("PATCH").build()), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)matcher.matches(new HttpRequestBuilder().setMethod("OPTIONS").build()), (Matcher)Is.is((Object)false));
    }
}

