/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.HttpResponseBuilder;

public class HttpResponseBuilderTestCase {
    public static final String EXAMPLE_STRING = "exampleString";
    private MuleContext muleContext;
    private MuleMessage mockMuleMessage;
    private MuleEvent mockEvent;

    @Before
    public void setUp() {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.mockEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.mockMuleMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
    }

    @Test
    public void testContentLengthIsOverridden() throws Exception {
        HttpResponseBuilder httpResponseBuilder = new HttpResponseBuilder();
        int contentLengthDifferingPayloadSize = 12;
        this.mockMuleMessage(new ByteArrayInputStream(EXAMPLE_STRING.getBytes(StandardCharsets.UTF_8)), contentLengthDifferingPayloadSize);
        HttpResponse httpResponse = httpResponseBuilder.build(new org.mule.module.http.internal.domain.response.HttpResponseBuilder(), this.mockEvent);
        Assert.assertThat((Object)httpResponse.getHeaderValue("Content-Length"), (Matcher)Matchers.is((Object)String.valueOf(EXAMPLE_STRING.length())));
    }

    private void mockMuleMessage(InputStream payload, int contentLength) {
        this.mockMuleMessage = new DefaultMuleMessage((Object)payload, this.muleContext);
        this.mockMuleMessage.setOutboundProperty("Content-Length", (Object)contentLength);
        Mockito.when((Object)this.mockEvent.getMessage()).thenReturn((Object)this.mockMuleMessage);
    }
}

