/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.util.Collections;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.transformer.DataType;
import org.mule.config.i18n.CoreMessages;
import org.mule.execution.ResponseCompletionCallback;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.HttpMessageProcessorTemplate;
import org.mule.module.http.internal.listener.HttpResponseBuilder;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;
import org.mule.transport.NullPayload;

@SmallTest
public class HttpMessageProcessorTemplateTestCase
extends AbstractMuleTestCase {
    private static final String TEST_MESSAGE = "";

    @Test
    public void statusCodeOnFailures() throws Exception {
        MuleEvent testEvent = this.createMockEvent();
        HttpResponseReadyCallback responseReadyCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        ArgumentCaptor httpResponseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseReadyCallback)Mockito.doNothing().when((Object)responseReadyCallback)).responseReady((HttpResponse)httpResponseCaptor.capture(), (ResponseStatusCallback)org.mockito.Matchers.any(ResponseStatusCallback.class));
        HttpMessageProcessorTemplate httpMessageProcessorTemplate = new HttpMessageProcessorTemplate(testEvent, (MessageProcessor)Mockito.mock(MessageProcessor.class), responseReadyCallback, null, HttpResponseBuilder.emptyInstance((MuleContext)((MuleContext)Mockito.mock(MuleContext.class))));
        httpMessageProcessorTemplate.sendFailureResponseToClient(new MessagingException(CoreMessages.createStaticMessage((String)TEST_MESSAGE), testEvent), null);
        Assert.assertThat((Object)((HttpResponse)httpResponseCaptor.getValue()).getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
    }

    @Test
    public void statusCodeOnExceptionBuildingResponse() throws Exception {
        MuleEvent testEvent = this.createMockEvent();
        HttpResponseReadyCallback responseReadyCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        ArgumentCaptor httpResponseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseReadyCallback)Mockito.doNothing().when((Object)responseReadyCallback)).responseReady((HttpResponse)httpResponseCaptor.capture(), (ResponseStatusCallback)org.mockito.Matchers.any(ResponseStatusCallback.class));
        HttpMessageProcessorTemplate httpMessageProcessorTemplate = new HttpMessageProcessorTemplate(testEvent, (MessageProcessor)Mockito.mock(MessageProcessor.class), responseReadyCallback, null, HttpResponseBuilder.emptyInstance((MuleContext)((MuleContext)Mockito.mock(MuleContext.class))));
        ResponseCompletionCallback responseCompletionCallback = (ResponseCompletionCallback)Mockito.mock(ResponseCompletionCallback.class);
        httpMessageProcessorTemplate.sendResponseToClient(testEvent, responseCompletionCallback);
        ((ResponseCompletionCallback)Mockito.verify((Object)responseCompletionCallback)).responseSentWithFailure((Exception)org.mockito.Matchers.isA(NullPointerException.class), (MuleEvent)org.mockito.Matchers.eq((Object)testEvent));
        Assert.assertThat((Object)((HttpResponse)httpResponseCaptor.getValue()).getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
    }

    @Test
    public void statusCodeOnExceptionSendingResponse() throws Exception {
        MuleEvent testEvent = this.createMockEvent();
        HttpResponseReadyCallback responseReadyCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        RuntimeException expected = new RuntimeException("Some exception");
        ArgumentCaptor httpResponseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseReadyCallback)Mockito.doThrow((Throwable)expected).when((Object)responseReadyCallback)).responseReady((HttpResponse)httpResponseCaptor.capture(), (ResponseStatusCallback)org.mockito.Matchers.any(ResponseStatusCallback.class));
        HttpMessageProcessorTemplate httpMessageProcessorTemplate = new HttpMessageProcessorTemplate(testEvent, (MessageProcessor)Mockito.mock(MessageProcessor.class), responseReadyCallback, null, HttpResponseBuilder.emptyInstance((MuleContext)((MuleContext)Mockito.mock(MuleContext.class))));
        ResponseCompletionCallback responseCompletionCallback = (ResponseCompletionCallback)Mockito.mock(ResponseCompletionCallback.class);
        try {
            httpMessageProcessorTemplate.sendResponseToClient(testEvent, responseCompletionCallback);
            Assert.fail((String)"Expected exception");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e, (Matcher)IsSame.sameInstance((Object)expected));
        }
        ((ResponseCompletionCallback)Mockito.verify((Object)responseCompletionCallback, (VerificationMode)Mockito.never())).responseSentWithFailure((Exception)expected, testEvent);
        Assert.assertThat((Object)((HttpResponse)httpResponseCaptor.getValue()).getStatusCode(), (Matcher)Matchers.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
    }

    private MuleEvent createMockEvent() {
        MuleMessage testMessage = (MuleMessage)Mockito.mock(MuleMessage.class);
        Mockito.when((Object)testMessage.getOutboundPropertyNames()).thenReturn(Collections.emptySet());
        Mockito.when((Object)testMessage.getPayload()).thenReturn((Object)NullPayload.getInstance());
        DataType datatype = DataType.STRING_DATA_TYPE;
        Mockito.when((Object)testMessage.getDataType()).thenReturn((Object)datatype);
        MuleEvent testEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        Mockito.when((Object)testEvent.getMessage()).thenReturn((Object)testMessage);
        Mockito.when((Object)testEvent.getMuleContext()).thenReturn(Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS));
        return testEvent;
    }
}

