/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal.listener;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Answers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.RequestContext;
import org.mule.api.MuleContext;
import org.mule.api.config.MuleConfiguration;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.registry.RegistrationException;
import org.mule.execution.MessageProcessContext;
import org.mule.execution.MessageProcessTemplate;
import org.mule.execution.MessageProcessingManager;
import org.mule.module.http.api.HttpConstants;
import org.mule.module.http.internal.domain.ByteArrayHttpEntity;
import org.mule.module.http.internal.domain.HttpProtocol;
import org.mule.module.http.internal.domain.request.ClientConnection;
import org.mule.module.http.internal.domain.request.HttpRequest;
import org.mule.module.http.internal.domain.request.HttpRequestContext;
import org.mule.module.http.internal.domain.response.HttpResponse;
import org.mule.module.http.internal.listener.DefaultHttpListener;
import org.mule.module.http.internal.listener.DefaultHttpListenerConfig;
import org.mule.module.http.internal.listener.HttpListenerConnectionManager;
import org.mule.module.http.internal.listener.HttpMessageProcessorTemplate;
import org.mule.module.http.internal.listener.ListenerPath;
import org.mule.module.http.internal.listener.RequestHandlerManager;
import org.mule.module.http.internal.listener.async.HttpResponseReadyCallback;
import org.mule.module.http.internal.listener.async.RequestHandler;
import org.mule.module.http.internal.listener.async.ResponseStatusCallback;
import org.mule.module.http.internal.listener.matcher.ListenerRequestMatcher;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class HttpListenerTestCase
extends AbstractMuleTestCase {
    public static final String URI_PARAM_NAME = "uri-param-name";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private FlowConstruct mockFlowConstruct = (FlowConstruct)Mockito.mock(FlowConstruct.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private DefaultHttpListenerConfig mockHttpListenerConfig = (DefaultHttpListenerConfig)Mockito.mock(DefaultHttpListenerConfig.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());
    private HttpListenerConnectionManager mockHttpListenerConnectionManager = (HttpListenerConnectionManager)Mockito.mock(HttpListenerConnectionManager.class, (Answer)Answers.RETURNS_DEEP_STUBS.get());

    @Test
    public void cannotHaveTwoUriParamsWithSameName() throws Exception {
        String listenerPath = String.format("/{%s}/{%s}", URI_PARAM_NAME, URI_PARAM_NAME);
        this.useInvalidPath(listenerPath);
    }

    @Test
    public void cannotHaveWildcardWithOtherCharacters() throws Exception {
        this.useInvalidPath("/path/*pepe");
    }

    @Test
    public void eventCreation() throws Exception {
        final AtomicReference requestHandlerRef = new AtomicReference();
        Mockito.when((Object)this.mockHttpListenerConfig.addRequestHandler((ListenerRequestMatcher)Matchers.any(ListenerRequestMatcher.class), (RequestHandler)Matchers.any(RequestHandler.class))).then((Answer)new Answer<RequestHandlerManager>(){

            public RequestHandlerManager answer(InvocationOnMock invocation) throws Throwable {
                requestHandlerRef.set((RequestHandler)invocation.getArguments()[1]);
                return null;
            }
        });
        this.usePath("/");
        Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        HttpResponseReadyCallback responseCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        ((HttpResponseReadyCallback)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
                return null;
            }
        }).when((Object)responseCallback)).responseReady((HttpResponse)Matchers.any(HttpResponse.class), (ResponseStatusCallback)Matchers.any(ResponseStatusCallback.class));
        HttpRequest request = this.buildGetRootRequest(HttpProtocol.HTTP_1_1);
        Mockito.when((Object)request.getHeaderValueIgnoreCase("Host")).thenReturn((Object)"localhost");
        HttpRequestContext requestContext = this.buildRequestContext(request);
        ((RequestHandler)requestHandlerRef.get()).handleRequest(requestContext, responseCallback);
        Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void eventCreationWithInvalidPath() throws Exception {
        final AtomicReference requestHandlerRef = new AtomicReference();
        Mockito.when((Object)this.mockHttpListenerConfig.addRequestHandler((ListenerRequestMatcher)Matchers.any(ListenerRequestMatcher.class), (RequestHandler)Matchers.any(RequestHandler.class))).then((Answer)new Answer<RequestHandlerManager>(){

            public RequestHandlerManager answer(InvocationOnMock invocation) throws Throwable {
                requestHandlerRef.set((RequestHandler)invocation.getArguments()[1]);
                return null;
            }
        });
        this.useInvalidPath("/");
        Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        ((RequestHandler)requestHandlerRef.get()).handleRequest((HttpRequestContext)Mockito.mock(HttpRequestContext.class), (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class));
        Assert.assertThat((Object)RequestContext.getEvent(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void noHostHeaderOn10Request() throws Exception {
        final AtomicReference requestHandlerRef = new AtomicReference();
        Mockito.when((Object)this.mockHttpListenerConfig.addRequestHandler((ListenerRequestMatcher)Matchers.any(ListenerRequestMatcher.class), (RequestHandler)Matchers.any(RequestHandler.class))).then((Answer)new Answer<RequestHandlerManager>(){

            public RequestHandlerManager answer(InvocationOnMock invocation) throws Throwable {
                requestHandlerRef.set((RequestHandler)invocation.getArguments()[1]);
                return null;
            }
        });
        this.usePath("/");
        HttpRequest request = this.buildGetRootRequest(HttpProtocol.HTTP_1_0);
        HttpRequestContext requestContext = this.buildRequestContext(request);
        HttpResponseReadyCallback responseCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        ((RequestHandler)requestHandlerRef.get()).handleRequest(requestContext, responseCallback);
        this.assertResponse(responseCallback, HttpConstants.HttpStatus.OK.getStatusCode());
    }

    @Test
    public void noHostHeaderOn11Request() throws Exception {
        final AtomicReference requestHandlerRef = new AtomicReference();
        Mockito.when((Object)this.mockHttpListenerConfig.addRequestHandler((ListenerRequestMatcher)Matchers.any(ListenerRequestMatcher.class), (RequestHandler)Matchers.any(RequestHandler.class))).then((Answer)new Answer<RequestHandlerManager>(){

            public RequestHandlerManager answer(InvocationOnMock invocation) throws Throwable {
                requestHandlerRef.set((RequestHandler)invocation.getArguments()[1]);
                return null;
            }
        });
        this.usePath("/");
        HttpRequest request = this.buildGetRootRequest(HttpProtocol.HTTP_1_1);
        HttpRequestContext requestContext = this.buildRequestContext(request);
        HttpResponseReadyCallback responseCallback = (HttpResponseReadyCallback)Mockito.mock(HttpResponseReadyCallback.class);
        ((RequestHandler)requestHandlerRef.get()).handleRequest(requestContext, responseCallback);
        this.assertResponse(responseCallback, HttpConstants.HttpStatus.BAD_REQUEST.getStatusCode(), HttpConstants.HttpStatus.BAD_REQUEST.getReasonPhrase(), "Missing 'host' header");
    }

    protected HttpRequest buildGetRootRequest(HttpProtocol protocol) {
        HttpRequest request = (HttpRequest)Mockito.mock(HttpRequest.class);
        Mockito.when((Object)request.getHeaderValue("Host")).thenReturn(null);
        Mockito.when((Object)request.getPath()).thenReturn((Object)"/");
        Mockito.when((Object)request.getUri()).thenReturn((Object)"/");
        Mockito.when((Object)request.getMethod()).thenReturn((Object)"GET");
        Mockito.when((Object)request.getProtocol()).thenReturn((Object)protocol);
        return request;
    }

    protected HttpRequestContext buildRequestContext(HttpRequest request) {
        ClientConnection clientConnection = (ClientConnection)Mockito.mock(ClientConnection.class);
        Mockito.when((Object)clientConnection.getRemoteHostAddress()).thenReturn((Object)InetSocketAddress.createUnresolved("localhost", 80));
        HttpRequestContext requestContext = (HttpRequestContext)Mockito.mock(HttpRequestContext.class);
        Mockito.when((Object)requestContext.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)requestContext.getClientConnection()).thenReturn((Object)clientConnection);
        Mockito.when((Object)requestContext.getScheme()).thenReturn((Object)HttpConstants.Protocols.HTTP.getScheme());
        return requestContext;
    }

    protected void assertResponse(HttpResponseReadyCallback responseCallback, int statusCode) {
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseReadyCallback)Mockito.verify((Object)responseCallback)).responseReady((HttpResponse)responseCaptor.capture(), (ResponseStatusCallback)Matchers.any(ResponseStatusCallback.class));
        Assert.assertThat((Object)((HttpResponse)responseCaptor.getValue()).getStatusCode(), (Matcher)CoreMatchers.is((Object)statusCode));
    }

    protected void assertResponse(HttpResponseReadyCallback responseCallback, int statusCode, String reason, String body) {
        ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(HttpResponse.class);
        ((HttpResponseReadyCallback)Mockito.verify((Object)responseCallback)).responseReady((HttpResponse)responseCaptor.capture(), (ResponseStatusCallback)Matchers.any(ResponseStatusCallback.class));
        Assert.assertThat((Object)((HttpResponse)responseCaptor.getValue()).getStatusCode(), (Matcher)CoreMatchers.is((Object)statusCode));
        Assert.assertThat((Object)((HttpResponse)responseCaptor.getValue()).getReasonPhrase(), (Matcher)CoreMatchers.is((Object)reason));
        Assert.assertThat((Object)((ByteArrayHttpEntity)((HttpResponse)responseCaptor.getValue()).getEntity()).getContent(), (Matcher)CoreMatchers.is((Object)body.getBytes()));
    }

    private void useInvalidPath(String listenerPath) throws InitialisationException {
        DefaultHttpListener httpListener = new DefaultHttpListener();
        httpListener.setMuleContext(this.mockMuleContext);
        httpListener.setFlowConstruct(this.mockFlowConstruct);
        httpListener.setConfig(this.mockHttpListenerConfig);
        Mockito.when((Object)this.mockHttpListenerConfig.getFullListenerPath(Matchers.anyString())).thenReturn((Object)new ListenerPath(null, listenerPath));
        Mockito.when((Object)this.mockMuleContext.getRegistry().get("_httpListenerConnectionManager")).thenReturn((Object)this.mockHttpListenerConnectionManager);
        httpListener.setPath(listenerPath);
        this.expectedException.expect(InitialisationException.class);
        httpListener.initialise();
    }

    private void usePath(String listenerPath) throws InitialisationException, RegistrationException {
        MuleContext mockMuleContext = (MuleContext)Mockito.mock(MuleContext.class);
        Mockito.when((Object)mockMuleContext.getRegistry()).thenReturn(Mockito.mock(MuleRegistry.class));
        Mockito.when((Object)mockMuleContext.getConfiguration()).thenReturn(Mockito.mock(MuleConfiguration.class));
        Mockito.when((Object)mockMuleContext.getConfiguration().getDefaultEncoding()).thenReturn((Object)"UTF-8");
        DefaultHttpListener httpListener = new DefaultHttpListener();
        httpListener.setMuleContext(mockMuleContext);
        httpListener.setFlowConstruct(this.mockFlowConstruct);
        httpListener.setConfig(this.mockHttpListenerConfig);
        Mockito.when((Object)this.mockHttpListenerConfig.getFullListenerPath(Matchers.anyString())).thenReturn((Object)new ListenerPath(null, listenerPath));
        MessageProcessingManager messageProcessingManager = (MessageProcessingManager)Mockito.mock(MessageProcessingManager.class);
        ((MessageProcessingManager)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                HttpMessageProcessorTemplate template = (HttpMessageProcessorTemplate)invocation.getArguments()[0];
                template.sendResponseToClient(null, null);
                return null;
            }
        }).when((Object)messageProcessingManager)).processMessage((MessageProcessTemplate)Matchers.any(HttpMessageProcessorTemplate.class), (MessageProcessContext)Matchers.any(MessageProcessContext.class));
        Mockito.when((Object)mockMuleContext.getRegistry().lookupObject(MessageProcessingManager.class)).thenReturn((Object)messageProcessingManager);
        Mockito.when((Object)mockMuleContext.getRegistry().get("_httpListenerConnectionManager")).thenReturn((Object)this.mockHttpListenerConnectionManager);
        httpListener.setPath(listenerPath);
        httpListener.initialise();
    }
}

