/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.http.internal.ParameterMap;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ParameterMapTestCase
extends AbstractMuleTestCase {
    public static final String KEY_1 = "key1";
    public static final String KEY_2 = "key2";
    public static final String KEY_3 = "key3";
    public static final String VALUE_1 = "value1";
    public static final String VALUE_2 = "value2";
    private ParameterMap parameterMap = new ParameterMap();

    @Test
    public void putAndGet() {
        Assert.assertThat((Object)this.parameterMap.put(KEY_1, VALUE_1), (Matcher)IsNull.nullValue());
        Assert.assertThat((Object)this.parameterMap.get((Object)KEY_1), (Matcher)Is.is((Object)VALUE_1));
        Assert.assertThat((Object)this.parameterMap.getAll(KEY_1), (Matcher)Is.is(Arrays.asList(VALUE_1)));
    }

    @Test
    public void secondPutReplaceOldValue() {
        this.parameterMap.put(KEY_1, VALUE_1);
        Assert.assertThat((Object)this.parameterMap.put(KEY_1, VALUE_2), (Matcher)Is.is((Object)VALUE_1));
        Assert.assertThat((Object)this.parameterMap.get((Object)KEY_1), (Matcher)Is.is((Object)VALUE_2));
        Assert.assertThat((Object)this.parameterMap.getAll(KEY_1), (Matcher)Is.is(Arrays.asList(VALUE_1, VALUE_2)));
    }

    @Test
    public void emptyMapKeySet() {
        Assert.assertThat((Object)this.parameterMap.keySet(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.parameterMap.keySet(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void keySetReturnAllKeys() {
        this.parameterMap.put(KEY_1, VALUE_1);
        this.parameterMap.put(KEY_2, VALUE_1);
        this.parameterMap.put(KEY_3, VALUE_1);
        Assert.assertThat((Object)this.parameterMap.keySet(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{KEY_1, KEY_2, KEY_3}));
    }

    @Test
    public void emptyValuesKeySet() {
        Assert.assertThat((Object)this.parameterMap.values(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.parameterMap.values(), (Matcher)Matchers.hasSize((int)0));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableParameterMapFailsOnPut() {
        this.parameterMap.toImmutableParameterMap().put(KEY_1, VALUE_1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableParameterMapFailsOnPutAll() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(KEY_1, VALUE_1);
        this.parameterMap.toImmutableParameterMap().putAll(map);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableParameterMapFailsOnRemove() {
        this.parameterMap.toImmutableParameterMap().remove((Object)KEY_1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void immutableParameterMapFailsOnClear() {
        this.parameterMap.toImmutableParameterMap().clear();
    }

    @Test
    public void valuesReturnsOnlyFirstValue() {
        this.parameterMap.put(KEY_1, VALUE_1);
        this.parameterMap.put(KEY_2, VALUE_2);
        this.parameterMap.put(KEY_3, VALUE_1);
        this.parameterMap.put(KEY_3, VALUE_2);
        Collection values = this.parameterMap.values();
        Assert.assertThat((Object)values, (Matcher)Matchers.hasSize((int)3));
        Assert.assertThat((Object)values, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{VALUE_1, VALUE_2, VALUE_2}));
    }

    @Test
    public void toListMapValueWithEmptyMap() {
        Assert.assertThat((Object)this.parameterMap.toListValuesMap().size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void toListMapValueWithSingleValues() {
        this.parameterMap.put(KEY_1, VALUE_1);
        this.parameterMap.put(KEY_2, VALUE_2);
        Assert.assertThat(this.parameterMap.toListValuesMap().get(KEY_1), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_1}));
        Assert.assertThat(this.parameterMap.toListValuesMap().get(KEY_2), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_2}));
    }

    @Test
    public void toListMapValueWithSeveralValues() {
        this.parameterMap.put(KEY_1, VALUE_1);
        this.parameterMap.put(KEY_1, VALUE_2);
        this.parameterMap.put(KEY_2, VALUE_1);
        this.parameterMap.put(KEY_2, VALUE_2);
        Assert.assertThat(this.parameterMap.toListValuesMap().get(KEY_1), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_1, VALUE_2}));
        Assert.assertThat(this.parameterMap.toListValuesMap().get(KEY_2), (Matcher)Matchers.hasItems((Object[])new String[]{VALUE_1, VALUE_2}));
    }
}

