/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.sni.SNIConfig;
import org.glassfish.grizzly.sni.SNIFilter;
import org.glassfish.grizzly.sni.SNIServerConfigResolver;
import org.glassfish.grizzly.ssl.SSLBaseFilter;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.util.ClassUtils;

public class HttpsRequesterSniTestCase
extends FunctionalTestCase {
    private static final String FQDN = "localhost.localdomain";
    private static final String SERVER_PROTOCOL_ENABLED = "SSLv3,TLSv1,TLSv1.1,TLSv1.2";
    @Rule
    public DynamicPort httpsPort = new DynamicPort("httpsPort");
    private Server server;

    protected String getConfigFile() {
        return "http-request-sni-config.xml";
    }

    @BeforeClass
    public static void createTlsPropertiesFile() throws Exception {
        PrintWriter writer = new PrintWriter(HttpsRequesterSniTestCase.getTlsPropertiesFile(), "UTF-8");
        writer.println("enabledProtocols=SSLv3,TLSv1,TLSv1.1,TLSv1.2");
        writer.close();
    }

    @AfterClass
    public static void removeTlsPropertiesFile() {
        HttpsRequesterSniTestCase.getTlsPropertiesFile().delete();
    }

    private static File getTlsPropertiesFile() {
        String path = System.getProperty("testClasspathDir");
        if (path == null) {
            path = ClassUtils.getClassPathRoot(HttpsRequesterSniTestCase.class).getPath();
        }
        return new File(path, String.format("tls-%s.conf", "default"));
    }

    @Before
    public void prepareServer() throws IOException {
        this.server = new Server(this.httpsPort.getNumber());
        this.server.startServer();
    }

    @After
    public void teardownServer() {
        if (this.server != null) {
            this.server.stopServer();
        }
    }

    @Test(expected=MessagingException.class)
    public void testClientSNINotSentOnNonFQDN() throws Exception {
        this.runFlow("requestFlowLocalhost", HttpsRequesterSniTestCase.getTestEvent((Object)"Test Message"));
    }

    @Test
    public void testClientSNISentOnFQDN() throws Exception {
        InetAddress address = null;
        try {
            address = InetAddress.getByName(FQDN);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assume.assumeThat((Object)address, (Matcher)Is.is((Matcher)CoreMatchers.notNullValue()));
        this.runFlow("requestFlowFQDN", HttpsRequesterSniTestCase.getTestEvent((Object)"Test Message"));
        Assert.assertThat((Object)this.server.getHostname(), (Matcher)Is.is((Object)FQDN));
    }

    protected MuleEvent runFlow(String flowName, MuleEvent event) throws Exception {
        Flow flow = this.lookupFlowConstruct(flowName);
        return flow.process(event);
    }

    public class Server {
        HttpServer webServer;
        final AtomicReference<String> sniHostname = new AtomicReference();
        int port;
        SSLEngineConfigurator sslServerEngineConfig;

        public Server(int port) {
            this.port = port;
        }

        protected void startServer() throws IOException {
            NetworkListener networkListener = new NetworkListener("sample-listener", "localhost", this.port);
            this.sslServerEngineConfig = new SSLEngineConfigurator(this.createSSLContextConfigurator().createSSLContext(), false, false, false);
            networkListener.setSSLEngineConfig(this.sslServerEngineConfig);
            this.webServer = HttpServer.createSimpleServer();
            this.webServer.addListener(networkListener);
            networkListener.setSecure(true);
            networkListener.registerAddOn((AddOn)new SniAddOn());
            this.webServer.start();
        }

        protected void stopServer() {
            this.sniHostname.set("");
            this.webServer.shutdownNow();
        }

        private SNIFilter getSniFilter() {
            final Attribute sniHostAttr = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("sni-host-attr");
            SNIFilter sniFilter = new SNIFilter();
            sniFilter.setServerSSLConfigResolver(new SNIServerConfigResolver(){

                public SNIConfig resolve(Connection connection, String hostname) {
                    sniHostAttr.set((AttributeStorage)connection, (Object)hostname);
                    Server.this.sniHostname.set(hostname);
                    if (StringUtils.isEmpty((String)hostname)) {
                        throw new IllegalArgumentException("SNI Has not been sent");
                    }
                    return SNIConfig.newServerConfig((SSLEngineConfigurator)Server.this.sslServerEngineConfig);
                }
            });
            return sniFilter;
        }

        private SSLContextConfigurator createSSLContextConfigurator() {
            URL keystoreUrl;
            SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
            ClassLoader cl = HttpsRequesterSniTestCase.class.getClassLoader();
            URL cacertsUrl = cl.getResource("tls/sni-server-truststore.jks");
            if (cacertsUrl != null) {
                sslContextConfigurator.setTrustStoreFile(cacertsUrl.getFile());
                sslContextConfigurator.setTrustStorePass("changeit");
            }
            if ((keystoreUrl = cl.getResource("tls/sni-server-keystore.jks")) != null) {
                sslContextConfigurator.setKeyStoreFile(keystoreUrl.getFile());
                sslContextConfigurator.setKeyStorePass("changeit");
                sslContextConfigurator.setKeyPass("changeit");
            }
            return sslContextConfigurator;
        }

        public String getHostname() {
            return this.sniHostname.get();
        }

        private class SniAddOn
        implements AddOn {
            private SniAddOn() {
            }

            public void setup(NetworkListener networkListener, FilterChainBuilder builder) {
                int idx = builder.indexOfType(SSLBaseFilter.class);
                if (idx != -1) {
                    builder.set(idx, (Filter)Server.this.getSniFilter());
                }
            }
        }
    }
}

