/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.internal.matchers.ThrowableMessageMatcher;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.tck.junit4.FunctionalTestCase;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;

@RunWith(value=Parameterized.class)
public class HttpRequestTlsInsecureTestCase
extends FunctionalTestCase {
    @Parameterized.Parameter
    public String config;
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");
    @Rule
    public SystemProperty insecure = new SystemProperty("insecure", "true");
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    protected String getConfigFile() {
        return this.config;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"http-request-insecure-hostname-config.xml"}, {"http-request-insecure-certificate-config.xml"});
    }

    @Test
    public void insecureRequest() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("testInsecureRequest");
        MuleEvent res = flow.process(HttpRequestTlsInsecureTestCase.getTestEvent((Object)"test"));
        Assert.assertThat((Object)res.getMessage().getPayloadAsString(), (Matcher)Is.is((Object)"test"));
    }

    @Test
    public void secureRequest() throws Exception {
        Flow flow = (Flow)this.getFlowConstruct("testSecureRequest");
        this.expectedException.expect(MessagingException.class);
        this.expectedException.expectCause(Matchers.isA(IOException.class));
        this.expectedException.expectCause(ThrowableMessageMatcher.hasMessage((Matcher)Matchers.containsString((String)"General SSLEngine problem")));
        flow.process(HttpRequestTlsInsecureTestCase.getTestEvent((Object)"test"));
    }
}

