/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.util.IOUtils;

public class HttpRequestStreamingTestCase
extends AbstractHttpRequestTestCase {
    private String transferEncodingHeader;
    private String contentLengthHeader;

    protected String getConfigFile() {
        return "http-request-streaming-config.xml";
    }

    @Test
    public void streamsWhenPayloadIsInputStreamAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes()));
        this.assertStreaming("streamingAuto", event);
    }

    @Test
    public void doesNotStreamWhenPayloadIsStringAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        this.assertNoStreaming("streamingAuto", event);
    }

    @Test
    public void doesNotStreamWithContentLengthHeaderAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes()));
        event.getMessage().setOutboundProperty("Content-Length", (Object)"Test Message".length());
        this.assertNoStreaming("streamingAuto", event);
    }

    @Test
    public void doesNotStreamStringWithContentLengthHeaderAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Content-Length", (Object)"Test Message".length());
        this.assertNoStreaming("streamingAuto", event);
    }

    @Test
    public void doesNotStreamWithContentLengthTransferEncodingHeadersAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes()));
        event.getMessage().setOutboundProperty("Content-Length", (Object)"Test Message".length());
        this.assertNoStreaming("streamingAutoHeader", event);
    }

    @Test
    public void doesNotStreamStringWithContentLengthTransferEncodingHeadersAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Content-Length", (Object)"Test Message".length());
        this.assertNoStreaming("streamingAutoHeader", event);
    }

    @Test
    public void streamsWhenPayloadIsStringTransferEncodingHeaderAndStreamingModeAuto() throws Exception {
        this.assertStreaming("streamingAutoHeader", HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message"));
    }

    @Test
    public void doesNotStreamWhenPayloadIsStringTransferEncodingPropertyAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Transfer-Encoding", (Object)"chunked");
        this.assertNoStreaming("streamingAuto", event);
    }

    @Test
    public void streamsWhenPayloadIsInputStreamTransferEncodingHeaderAndStreamingModeAuto() throws Exception {
        this.assertStreaming("streamingAutoHeader", HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes())));
    }

    @Test
    public void streamsWhenPayloadIsInputStreamTransferEncodingPropertyAndStreamingModeAuto() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes()));
        event.getMessage().setOutboundProperty("Transfer-Encoding", (Object)"chunked");
        this.assertStreaming("streamingAutoHeader", event);
    }

    @Test
    public void streamsWhenStreamingModeAlways() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        this.assertStreaming("streamingAlways", event);
    }

    @Test
    public void streamsWhenPayloadIsInputStreamAndStreamingModeAlways() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes()));
        this.assertStreaming("streamingAlways", event);
    }

    @Test
    public void streamsWithContentLengthHeaderAndStreamingModeAlways() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Content-Length", (Object)"Test Message".length());
        this.assertStreaming("streamingAlways", event);
    }

    @Test
    public void streamsWithTransferEncodingInvalidValueAndStreamingModeAlways() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Transfer-Encoding", (Object)"Invalid value");
        this.assertStreaming("streamingAlways", event);
    }

    @Test
    public void doesNotStreamWhenStreamingModeNever() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes()));
        this.assertNoStreaming("streamingNever", event);
    }

    @Test
    public void doesNotStreamWithTransferEncodingHeaderAndStreamingModeNever() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)new ByteArrayInputStream("Test Message".getBytes()));
        event.getMessage().setOutboundProperty("Transfer-Encoding", (Object)"chunked");
        this.assertNoStreaming("streamingNever", event);
    }

    @Test
    public void doesNotStreamWhenPayloadIsStringAndStreamingModeNever() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        this.assertNoStreaming("streamingNever", event);
    }

    @Test
    public void doesNotStreamWhenPayloadIsStringTransferEncodingHeaderAndStreamingModeNever() throws Exception {
        MuleEvent event = HttpRequestStreamingTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setOutboundProperty("Transfer-Encoding", (Object)"chunked");
        this.assertNoStreaming("streamingNever", event);
    }

    private void assertNoStreaming(String flowName, MuleEvent event) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent response = flow.process(event);
        Assert.assertNull((Object)this.transferEncodingHeader);
        Assert.assertThat((Object)Integer.parseInt(this.contentLengthHeader), (Matcher)CoreMatchers.equalTo((Object)"Test Message".length()));
        Assert.assertTrue((boolean)(response.getMessage().getPayload() instanceof InputStream));
        Assert.assertThat((Object)response.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"<h1>Response</h1>"));
    }

    private void assertStreaming(String flowName, MuleEvent event) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent response = flow.process(event);
        Assert.assertThat((Object)this.transferEncodingHeader, (Matcher)CoreMatchers.equalTo((Object)"chunked"));
        Assert.assertNull((Object)this.contentLengthHeader);
        Assert.assertTrue((boolean)(response.getMessage().getPayload() instanceof InputStream));
        Assert.assertThat((Object)response.getMessage().getPayloadAsString(), (Matcher)CoreMatchers.equalTo((Object)"<h1>Response</h1>"));
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        this.transferEncodingHeader = baseRequest.getHeader("Transfer-Encoding");
        this.contentLengthHeader = baseRequest.getHeader("Content-Length");
        IOUtils.toString((InputStream)request.getInputStream());
        response.setContentType("text/html");
        response.setStatus(200);
        response.getWriter().print("<h1>Response</h1>");
    }
}

