/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.http.functional.requester;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.junit.Assert;
import org.junit.Test;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.construct.Flow;
import org.mule.module.http.functional.requester.AbstractHttpRequestTestCase;
import org.mule.module.http.internal.request.ResponseValidatorException;

public class HttpRequestStatusCodesTestCase
extends AbstractHttpRequestTestCase {
    protected String getConfigFile() {
        return "http-request-status-codes-config.xml";
    }

    @Test
    public void defaultStatusCodeValidatorSuccess() throws Exception {
        this.assertSuccess(200, "default");
    }

    @Test
    public void defaultStatusCodeValidatorFailure() throws Exception {
        this.assertFailure(500, "default");
    }

    @Test
    public void successStatusCodeValidatorSuccess() throws Exception {
        this.assertSuccess(409, "success");
    }

    @Test
    public void successStatusCodeValidatorFailure() throws Exception {
        this.assertFailure(200, "success");
    }

    @Test
    public void failureStatusCodeValidatorSuccess() throws Exception {
        this.assertSuccess(200, "failure");
    }

    @Test
    public void failureStatusCodeValidatorFailure() throws Exception {
        this.assertFailure(201, "failure");
    }

    private void assertSuccess(int statusCode, String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent event = HttpRequestStatusCodesTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setInvocationProperty("code", (Object)statusCode);
        flow.process(event);
    }

    private void assertFailure(int statusCode, String flowName) throws Exception {
        Flow flow = (Flow)this.getFlowConstruct(flowName);
        MuleEvent event = HttpRequestStatusCodesTestCase.getTestEvent((Object)"Test Message");
        event.getMessage().setInvocationProperty("code", (Object)statusCode);
        try {
            flow.process(event);
            Assert.fail();
        }
        catch (MessagingException e) {
            MuleMessage response = e.getEvent().getMessage();
            Assert.assertNotNull((Object)response.getExceptionPayload());
            Assert.assertTrue((boolean)(response.getExceptionPayload().getException() instanceof ResponseValidatorException));
        }
    }

    @Override
    protected void handleRequest(Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        int statusCode = Integer.parseInt(request.getParameter("code"));
        response.setContentType("text/html");
        response.setStatus(statusCode);
        response.getWriter().print("<h1>Response</h1>");
    }
}

